/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.morilib.db.gui.RelationEditorTableModel;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.schema.SqlSchema;

public class EditorPanel
extends JPanel {
    private SqlSchema schema;
    private JTable table;

    public EditorPanel(SqlSchema f) {
        this.schema = f;
        this.setLayout(new BorderLayout());
        final JMenuItem i1 = new JMenuItem("delete");
        i1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == i1) {
                    TableModel m = EditorPanel.this.table.getModel();
                    int[] a = EditorPanel.this.table.getSelectedRows();
                    if (m instanceof RelationEditorTableModel) {
                        RelationEditorTableModel r = (RelationEditorTableModel)m;
                        if (JOptionPane.showConfirmDialog(EditorPanel.this.table, String.valueOf(a.length) + " rows will be deleted, sure?", "delete rows", 0) == 0) {
                            Arrays.sort(a);
                            int i = a.length - 1;
                            while (i >= 0) {
                                r.deleteTuple(a[i]);
                                --i;
                            }
                        }
                    }
                }
            }
        });
        final JPopupMenu p1 = new JPopupMenu();
        p1.add(i1);
        this.table = new JTable();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableModel m = EditorPanel.this.table.getModel();
                if (m instanceof RelationEditorTableModel) {
                    try {
                        RelationEditorTableModel r = (RelationEditorTableModel)m;
                        r.write(EditorPanel.this.schema);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(EditorPanel.this, "", "IO error", 0);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(EditorPanel.this, e1.getMessage(), "SQL error", 0);
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    i1.setEnabled(EditorPanel.this.table.getSelectedRow() >= 0);
                    p1.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        final JComboBox c1 = new JComboBox(new TL());
        c1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String n = ((TL)c1.getModel()).sel;
                    NamedRelation r = EditorPanel.this.schema.readRelation(n, null);
                    EditorPanel.this.table.setModel(new RelationEditorTableModel(n, r));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(EditorPanel.this, "", "IO error", 0);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(EditorPanel.this, e1.getMessage(), "SQL error", 0);
                }
            }
        });
        this.add(c1, "North");
    }

    private class TL
    extends AbstractListModel
    implements ComboBoxModel {
        String sel;

        private TL() {
        }

        @Override
        public int getSize() {
            try {
                return EditorPanel.this.schema.getTableNames().size();
            }
            catch (IOException e) {
                return 0;
            }
            catch (SQLException e) {
                return 0;
            }
        }

        @Override
        public Object getElementAt(int index) {
            try {
                Iterator<String> itr = EditorPanel.this.schema.getTableNames().iterator();
                int i = 0;
                while (itr.hasNext() && i < index) {
                    itr.next();
                    ++i;
                }
                return itr.next();
            }
            catch (IOException e) {
                return "(fail to get)";
            }
            catch (SQLException e) {
                return "(fail to get)";
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.sel = anItem.toString();
        }

        @Override
        public Object getSelectedItem() {
            return this.sel;
        }
    }
}

