/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.engine.SqlEngineFactory;
import net.morilib.db.gui.RelationQueryTableModel;
import net.morilib.db.relations.Relation;
import net.morilib.db.schema.SqlSchema;

public class QueryPanel
extends JPanel {
    private SqlSchema schema;
    private JTextArea area;
    private JTable table;

    private Object exec() throws IOException, SQLException {
        SqlEngine e = SqlEngineFactory.getInstance().getEngine(this.schema);
        return e.execute(this.area.getText());
    }

    public QueryPanel(SqlSchema f) {
        this.schema = f;
        this.setLayout(new BorderLayout());
        this.area = new JTextArea();
        final JSplitPane sp = new JSplitPane(0, this.area, new JPanel());
        sp.setDividerLocation(300);
        this.add((Component)sp, "Center");
        JButton b = new JButton("execute");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object o = QueryPanel.this.exec();
                    if (o instanceof Relation) {
                        Relation r = (Relation)o;
                        RelationQueryTableModel m = new RelationQueryTableModel(r);
                        QueryPanel.this.table = new JTable(m);
                        QueryPanel.this.table.setSelectionMode(2);
                        sp.setBottomComponent(new JScrollPane(QueryPanel.this.table));
                    } else if (o instanceof Integer) {
                        JTextArea c = new JTextArea();
                        c.setText(o + " columns processed");
                        c.setEditable(false);
                        sp.setBottomComponent(c);
                    } else {
                        JTextArea c = new JTextArea();
                        c.setText(o.toString());
                        c.setEditable(false);
                        sp.setBottomComponent(c);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(QueryPanel.this, "", "IO error", 0);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(QueryPanel.this, e1.getMessage(), "IO error", 0);
                }
            }
        });
        this.add((Component)b, "North");
    }
}

