/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.info;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import net.morilib.db.jdbc.BeanListResultSet;
import net.morilib.db.misc.LikeWildcard;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class ColumnsInfo {
    static final String[] INFO = new String[]{"tableCat", "tableSchem", "tableName", "columnName", "dataType", "typeName", "columnSize", "bufferLength", "decimalDigit", "numPrecRadix", "nullable", "remarks", "columnDef", "sqlDataType", "sqlDatetimeSub", "charOctetLength", "ordinalPosition", "isNullable", "scopeCatalog", "scopeSchema", "sourceDataType", "isAutoincrement"};
    private String tableCat;
    private String tableSchem;
    private String tableName;
    private String columnName;
    private Integer dataType;
    private String typeName;
    private Integer columnSize;
    private Integer bufferLength;
    private Integer decimalDigit;
    private Integer numPrecRadix;
    private Integer nullable;
    private String remarks;
    private String columnDef;
    private Integer sqlDataType;
    private Integer sqlDatetimeSub;
    private Integer charOctetLength;
    private Integer ordinalPosition;
    private String isNullable;
    private String scopeCatalog;
    private String scopeSchema;
    private short sourceDataType;
    private String isAutoincrement;

    public static BeanListResultSet get(SqlSchema sql, String tn, String cn) throws IOException, SQLException {
        ArrayList<ColumnsInfo> l = new ArrayList<ColumnsInfo>();
        LikeWildcard tw = LikeWildcard.compile(tn != null ? tn : "%");
        LikeWildcard cw = LikeWildcard.compile(cn != null ? cn : "%");
        for (String s : sql.getTableNames()) {
            if (!tw.matches(s.toUpperCase()) && !tw.matches(s.toLowerCase())) continue;
            SqlCreateTable t = sql.getCreateTable(s);
            int i = 0;
            while (i < t.getColumnDefinitions().size()) {
                SqlColumnDefinition d = t.getColumnDefinitions().get(i);
                if (cw.matches(d.getName().toUpperCase()) || cw.matches(d.getName().toLowerCase())) {
                    ColumnsInfo f = new ColumnsInfo();
                    f.tableName = s.toUpperCase();
                    f.columnName = d.getName();
                    f.dataType = d.getType().getSqlType();
                    f.typeName = d.getType().toString();
                    f.columnSize = d.getType().getLength();
                    f.decimalDigit = d.getType().getScale();
                    f.numPrecRadix = 10;
                    f.nullable = d.getAttributes().contains((Object)SqlColumnAttribute.NOT_NULL) ? 0 : 1;
                    f.ordinalPosition = i + 1;
                    f.isNullable = d.getAttributes().contains((Object)SqlColumnAttribute.NOT_NULL) ? "NO" : "YES";
                    f.isAutoincrement = "NO";
                    l.add(f);
                }
                ++i;
            }
        }
        return new BeanListResultSet(ColumnsInfo.class, Arrays.asList(INFO), l);
    }

    public Integer getBufferLength() {
        return this.bufferLength;
    }

    public void setBufferLength(Integer bufferLength) {
        this.bufferLength = bufferLength;
    }

    public String getTableCat() {
        return this.tableCat;
    }

    public void setTableCat(String tableCat) {
        this.tableCat = tableCat;
    }

    public String getTableSchem() {
        return this.tableSchem;
    }

    public void setTableSchem(String tableSchem) {
        this.tableSchem = tableSchem;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(Integer columnSize) {
        this.columnSize = columnSize;
    }

    public Integer getDecimalDigit() {
        return this.decimalDigit;
    }

    public void setDecimalDigit(Integer decimalDigit) {
        this.decimalDigit = decimalDigit;
    }

    public Integer getNumPrecRadix() {
        return this.numPrecRadix;
    }

    public void setNumPrecRadix(Integer numPrecRadix) {
        this.numPrecRadix = numPrecRadix;
    }

    public Integer getNullable() {
        return this.nullable;
    }

    public void setNullable(Integer nullable) {
        this.nullable = nullable;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getColumnDef() {
        return this.columnDef;
    }

    public void setColumnDef(String columnDef) {
        this.columnDef = columnDef;
    }

    public Integer getSqlDataType() {
        return this.sqlDataType;
    }

    public void setSqlDataType(Integer sqlDataType) {
        this.sqlDataType = sqlDataType;
    }

    public Integer getSqlDatetimeSub() {
        return this.sqlDatetimeSub;
    }

    public void setSqlDatetimeSub(Integer sqlDatetimeSub) {
        this.sqlDatetimeSub = sqlDatetimeSub;
    }

    public Integer getCharOctetLength() {
        return this.charOctetLength;
    }

    public void setCharOctetLength(Integer charOctetLength) {
        this.charOctetLength = charOctetLength;
    }

    public Integer getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(Integer ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public String getIsNullable() {
        return this.isNullable;
    }

    public void setIsNullable(String isNullable) {
        this.isNullable = isNullable;
    }

    public String getScopeCatalog() {
        return this.scopeCatalog;
    }

    public void setScopeCatalog(String scopeCatalog) {
        this.scopeCatalog = scopeCatalog;
    }

    public String getScopeSchema() {
        return this.scopeSchema;
    }

    public void setScopeSchema(String scopeSchema) {
        this.scopeSchema = scopeSchema;
    }

    public short getSourceDataType() {
        return this.sourceDataType;
    }

    public void setSourceDataType(short sourceDataType) {
        this.sourceDataType = sourceDataType;
    }

    public String getIsAutoincrement() {
        return this.isAutoincrement;
    }

    public void setIsAutoincrement(String isAutoincrement) {
        this.isAutoincrement = isAutoincrement;
    }
}

