/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.db.misc.HTMLTermException;
import net.morilib.parser.html.HTMLHandler;

public class HTMLTableHandler
implements HTMLHandler {
    private List<List<String>> values = new ArrayList<List<String>>();
    private List<String> value;
    private List<String> extra;
    private StringBuffer buf;
    private String name;
    private int tblno;
    private S stat;

    public HTMLTableHandler(String n) {
        this.name = n;
        this.tblno = 0;
        this.stat = S.INIT;
    }

    public List<List<String>> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public void string(String s) {
        if (this.stat == S.TD) {
            this.buf.append(s);
        }
    }

    @Override
    public void startTag(String s) {
        switch (this.stat) {
            case INIT: {
                if (!s.equalsIgnoreCase("TABLE")) break;
                this.stat = S.TABLE_P;
                ++this.tblno;
                break;
            }
            case TABLE_P: {
                if (!this.name.equalsIgnoreCase("TABLE" + this.tblno)) break;
                this.stat = S.TABLE;
            }
            case TABLE: {
                if (!s.equalsIgnoreCase("TR")) break;
                this.value = new ArrayList<String>();
                this.stat = S.TR;
                break;
            }
            case TR: {
                if (!s.equalsIgnoreCase("TD") && !s.equalsIgnoreCase("TH")) break;
                this.buf = new StringBuffer();
                this.extra = new ArrayList<String>();
                this.extra.add(s);
                this.stat = S.TD;
                break;
            }
            case TD: {
                if (s.equalsIgnoreCase(this.extra.get(0))) {
                    this.value.add(this.buf.toString().trim());
                    this.buf = new StringBuffer();
                    break;
                }
                if (s.equalsIgnoreCase("TR")) {
                    this.value.add(this.buf.toString().trim());
                    this.values.add(Collections.unmodifiableList(this.value));
                    this.value = new ArrayList<String>();
                    this.stat = S.TR;
                    break;
                }
                this.buf.append('<').append(s).append(' ');
                this.extra.add(s);
                this.stat = S.EXTRA;
                break;
            }
            case EXTRA: {
                this.extra.add(s);
            }
        }
    }

    @Override
    public void endTag(String s) {
        switch (this.stat) {
            case INIT: {
                break;
            }
            case TABLE_P: {
                this.stat = S.INIT;
                break;
            }
            case TABLE: {
                if (!s.equalsIgnoreCase("TABLE")) break;
                throw new HTMLTermException();
            }
            case TR: {
                if (!s.equalsIgnoreCase("TR")) break;
                this.stat = S.TABLE;
                this.values.add(Collections.unmodifiableList(this.value));
                break;
            }
            case TD: {
                if (s.equalsIgnoreCase(this.extra.get(0))) {
                    this.stat = S.TR;
                    this.value.add(this.buf.toString().trim());
                    break;
                }
                if (!s.equalsIgnoreCase("TR")) break;
                this.stat = S.TABLE;
                this.value.add(this.buf.toString().trim());
                this.values.add(Collections.unmodifiableList(this.value));
                break;
            }
            case EXTRA: {
                while (this.extra.size() > 0 && !this.extra.get(this.extra.size() - 1).equalsIgnoreCase(s)) {
                    this.extra.remove(this.extra.size() - 1);
                }
                if (this.extra.size() > 1) break;
                if (this.extra.size() == 1) {
                    this.value.add(this.buf.toString().trim());
                    this.stat = S.TR;
                    break;
                }
                if (s.equalsIgnoreCase("TR")) {
                    this.values.add(Collections.unmodifiableList(this.value));
                    this.stat = S.TABLE;
                    break;
                }
                if (!s.equalsIgnoreCase("TABLE")) break;
                throw new HTMLTermException();
            }
        }
    }

    @Override
    public void tagAttribute(String k, String v) {
        switch (this.stat) {
            case INIT: {
                break;
            }
            case TABLE_P: {
                if (!k.equalsIgnoreCase("ID") || !v.equalsIgnoreCase(this.name) && !this.name.equalsIgnoreCase("TABLE" + this.tblno)) break;
                this.stat = S.TABLE;
                break;
            }
            case TABLE: {
                break;
            }
            case TR: {
                break;
            }
            case TD: {
                break;
            }
        }
    }

    @Override
    public void meta(String s) {
    }

    @Override
    public void comment(String s) {
    }

    private static enum S {
        INIT,
        TABLE_P,
        TABLE,
        TR,
        TD,
        EXTRA;

    }
}

