/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.httpd;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.morilib.httpd.Ecrire;

public final class HTTPUtils {
    private static final String MSG200 = "HTTP/1.0 200 OK\r\n";
    private static final String MSG400 = "HTTP/1.0 400 Bad Request\r\n";
    private static final String MSG404 = "HTTP/1.0 404 Not Found\r\n";
    private static final String MSG500 = "HTTP/1.0 500 Internal Error\r\n";
    static final Ecrire MESSAGE400 = new Ecrire(){

        @Override
        public void write(SocketChannel c) throws IOException {
            HTTPUtils.putBadRequest(c);
            c.close();
        }
    };
    static final Ecrire MESSAGE404 = new Ecrire(){

        @Override
        public void write(SocketChannel c) throws IOException {
            HTTPUtils.putNotFound(c);
            c.close();
        }
    };
    static final Ecrire MESSAGE500 = new Ecrire(){

        @Override
        public void write(SocketChannel c) throws IOException {
            HTTPUtils.putBadRequest(c);
            c.close();
        }
    };

    private HTTPUtils() {
    }

    public static void puterror(SocketChannel c, Throwable e) throws IOException {
        c.write(ByteBuffer.wrap(MSG500.getBytes()));
    }

    public static void putApplicationError(PrintWriter w, Throwable e) throws IOException {
        w.println("<html>");
        w.println("<head>");
        w.println("<title>500 Internal Error</title>");
        w.println("</head>");
        w.println("<body>");
        w.println("<h1>500 Internal Error</h1>");
        w.println("<pre>");
        e.printStackTrace(w);
        w.println("</pre>");
        w.println("</body>");
        w.println("</html>");
    }

    public static void putOk(SocketChannel c) throws IOException {
        c.write(ByteBuffer.wrap(MSG200.getBytes()));
    }

    public static void putBadRequest(SocketChannel c) throws IOException {
        c.write(ByteBuffer.wrap(MSG400.getBytes()));
    }

    public static void putNotFound(SocketChannel c) throws IOException {
        c.write(ByteBuffer.wrap(MSG404.getBytes()));
    }

    public static void put(SocketChannel c, String s) throws IOException {
        c.write(ByteBuffer.wrap(s.getBytes()));
    }
}

