/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.fichier;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class FileFichier implements Fichier {

	File file;

	FileFichier(File f) {
		file = f;
	}

	@Override
	public boolean isFile() {
		return file.isFile();
	}

	@Override
	public boolean createNewFile() throws IOException {
		return file.createNewFile();
	}

	@Override
	public Reader openReader() throws IOException {
		return new FileReader(file);
	}

	@Override
	public Writer openWriter() throws IOException {
		return new FileWriter(file);
	}

	@Override
	public InputStream openInputStream() throws IOException {
		return new FileInputStream(file);
	}

	@Override
	public OutputStream openOutputStream() throws IOException {
		return new FileOutputStream(file);
	}

	@Override
	public String getName() {
		return file.getName();
	}

	@Override
	public boolean delete() {
		return file.delete();
	}

	@Override
	public Fichier[] listFichiers() {
		File[] a = file.listFiles();
		Fichier[] f = new Fichier[a.length];

		for(int i = 0; i < a.length; i++) {
			f[i] = new FileFichier(a[i]);
		}
		return f;
	}

	@Override
	public boolean renameTo(Fichier name) {
		return file.renameTo(((FileFichier)name).file);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.fichier.Fichier#getParent()
	 */
	@Override
	public Fichier getParent() {
		return new FileFichier(file.getParentFile());
	}

}
