package net.morilib.db.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.RelationsLogger;

public class BeanListResultSet extends AbstractBeanResultSet {

	private static RelationsLogger logger = RelationsJDBCUtils.logger;

	private List<Object> list;
	private int ptr = -1;
	private Object last = "last";

	/**
	 * 
	 * @param c
	 * @param l
	 * @param m
	 */
	public BeanListResultSet(Class<?> c, List<String> l, List<?> m) {
		super(c, l);
		list = new ArrayList<Object>(m);
	}

	@Override
	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		return false;
	}

	@Override
	public <T> T unwrap(Class<T> arg0) throws SQLException {
		throw new SQLException("not supported");
	}

	@Override
	public boolean next() throws SQLException {
		return relative(1);
	}

	@Override
	public void close() throws SQLException {
		// ignore it
	}

	@Override
	public boolean wasNull() throws SQLException {
		return last.equals("");
	}

	static String _tolower(String s) {
		StringBuffer b = new StringBuffer();
		boolean e = false;
		char c;

		if(s.indexOf('_') < 0) {
			b.append(s);
			b.setCharAt(0, Character.toUpperCase(b.charAt(0)));
		} else {
			for(int i = 0; i < s.length(); i++) {
				c = s.charAt(i);
				if(b.length() == 0 || e) {
					b.append(Character.toUpperCase(c));
					e = false;
				} else if(c == '_') {
					e = true;
				} else {
					b.append(Character.toLowerCase(c));
					e = false;
				}
			}
		}
		return b.toString();
	}

	@Override
	public Object getObject(String columnLabel) throws SQLException {
		Object o, p;
		String s;
		Method m;

		logger.finer("getObject");
		if(ptr < 0 || ptr >= list.size()) {
			throw ErrorBundle.getDefault(20003);
		} else {
			try {
				s = "get" + _tolower(columnLabel);
				m = classe.getMethod(s);
				o = list.get(ptr);
				p = m.invoke(o);
				last = p == null ? "" : p;
				logger.finer(columnLabel + ":" + last);
				return last;
			} catch(SecurityException e) {
				throw new RuntimeException(e);
			} catch(NoSuchMethodException e) {
				throw ErrorBundle.getDefault(10009, columnLabel);
			} catch(IllegalArgumentException e) {
				throw new RuntimeException(e);
			} catch(IllegalAccessException e) {
				throw new RuntimeException(e);
			} catch(InvocationTargetException e) {
				throw new RuntimeException(e);
			}
		}
	}

	@Override
	public boolean isBeforeFirst() throws SQLException {
		return ptr < 0;
	}

	@Override
	public boolean isAfterLast() throws SQLException {
		return ptr >= list.size();
	}

	@Override
	public boolean isFirst() throws SQLException {
		return ptr == 0;
	}

	@Override
	public boolean isLast() throws SQLException {
		return ptr == list.size() - 1;
	}

	@Override
	public void beforeFirst() throws SQLException {
		ptr = -1;
	}

	@Override
	public void afterLast() throws SQLException {
		ptr = list.size();
	}

	@Override
	public boolean first() throws SQLException {
		ptr = 0;
		return list.size() > 0;
	}

	@Override
	public boolean last() throws SQLException {
		ptr = list.size() - 1;
		return list.size() > 0;
	}

	@Override
	public int getRow() throws SQLException {
		return ptr + 1;
	}

	@Override
	public boolean absolute(int row) throws SQLException {
		ptr = row < 0 ? list.size() + row : row - 1;
		ptr = ptr < 0 ? -1 : ptr > list.size() ? list.size() : ptr;
		return ptr >= 0 && ptr < list.size();
	}

	@Override
	public boolean relative(int rows) throws SQLException {
		ptr = ptr + rows;
		ptr = ptr < 0 ? -1 : ptr > list.size() ? list.size() : ptr;
		return ptr >= 0 && ptr < list.size();
	}

	@Override
	public boolean previous() throws SQLException {
		return relative(-1);
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		// ignore it
	}

	@Override
	public int getFetchDirection() throws SQLException {
		return FETCH_UNKNOWN;
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		// ignore it
	}

	@Override
	public int getFetchSize() throws SQLException {
		return 0;
	}

	@Override
	public int getType() throws SQLException {
		return TYPE_SCROLL_SENSITIVE;
	}

	@Override
	public int getConcurrency() throws SQLException {
		return CONCUR_READ_ONLY;
	}

	@Override
	public Statement getStatement() throws SQLException {
		return null;
	}

	@Override
	public int getHoldability() throws SQLException {
		return HOLD_CURSORS_OVER_COMMIT;
	}

	@Override
	public boolean isClosed() throws SQLException {
		return false;
	}

}
