/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

public class XmlTags {

	private static class RemTag implements HTMLHandler {

		String tag, idname, idval;

		private Map<String, String> tagw;
		private PrintWriter wr;
		private boolean tagr;

		RemTag(PrintWriter w, String t, String n, String v) {
			tagr = true;
			wr = w;
			tag = t;
			idname = n;
			idval = v;
		}

		private void puttagw() {
			if(tagw != null) {
				tagr = !tag.equals(tagw.get("")) ||
						!idval.equals(tagw.get(idname));
			}

			if(tagw != null && tagr) {
				wr.format("<%s", tagw.remove(""));
				for(String s : tagw.keySet()) {
					wr.format(" %s=\"%s\"", s, tagw.get(s));
				}
				wr.println('>');
			}
			tagw = null;
		}

		@Override
		public void string(String s) throws HTMLParseException {
			puttagw();
			if(tagr)  wr.print(HTMLParser.escape(s));
		}

		@Override
		public void startTag(String s) throws HTMLParseException {
			puttagw();
			tagw = new HashMap<String, String>();
			tagw.put("", s);
		}

		@Override
		public void endTag(String s) throws HTMLParseException {
			puttagw();
			if(tagr) {
				wr.format("</%s>", HTMLParser.escape(s));
			} else {
				tagr = tagr || s.equals(tag);
			}
		}

		@Override
		public void tagAttribute(String k,
				String v) throws HTMLParseException {
			tagw.put(k, v);
		}

		@Override
		public void meta(String s) throws HTMLParseException {
			wr.println(s);
		}

		@Override
		public void comment(String s) throws HTMLParseException {
			wr.format("<!--%s-->", s);
		}

	}

	/**
	 * 
	 * @param in
	 * @param os
	 * @param tag
	 * @param id
	 * @param val
	 * @throws IOException
	 * @throws SQLException
	 */
	public static void removeTag(InputStream in, OutputStream os,
			String tag, String id,
			String val) throws IOException, SQLException {
		BufferedReader b;
		PrintWriter w;
		RemTag h;

		b = new BufferedReader(new InputStreamReader(in, "UTF-8"));
		w = new PrintWriter(new BufferedWriter(
				new OutputStreamWriter(os, "UTF-8")));
		h = new RemTag(w, tag, id, val);
		try {
			HTMLParser.parse(h, b);
		} catch(HTMLParseException e) {
			throw (SQLException)e.getCause();
		}
		w.flush();
	}

}
