/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import net.morilib.db.misc.ErrorBundle;

public class DefaultRelationTuple implements RelationTuple {

	private Map<String, Object> tuple;

	public DefaultRelationTuple(Map<String, Object> t) {
		tuple = new LinkedHashMap<String, Object>(t);
	}

	public Object get(String name) throws SQLException {
		if(!tuple.containsKey(name)) {
			throw ErrorBundle.getDefault(10009, name);
		}
		return tuple.get(name);
	}

	@Override
	public RelationTuple copy() {
		return new DefaultRelationTuple(tuple);
	}

	@Override
	public Map<String, Object> toMap() throws SQLException {
		return Collections.unmodifiableMap(tuple);
	}

	public int hashCode() {
		return tuple.hashCode();
	}

	public boolean equals(Object o) {
		return (o instanceof DefaultRelationTuple &&
				tuple.equals(((DefaultRelationTuple)o).tuple));
	}

	public String toString() {
		return tuple.toString();
	}

}
