/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public class ResourceEcrire implements Ecrire {

	private String path;

	public ResourceEcrire(String path) {
		this.path = path;
	}

	@Override
	public void write(SocketChannel c) throws IOException {
		byte[] a = new byte[1024];
		InputStream ins = null;
		int l;

		try {
			ins = HTTPServer.class.getResourceAsStream("/" + path);
			if(ins == null) {
				HTTPUtils.putNotFound(c);
			} else {
				HTTPUtils.putOk(c);
				HTTPUtils.put(c, "\r\n");
				ins = new BufferedInputStream(ins);
				while((l = ins.read(a)) >= 0) {
					c.write(ByteBuffer.wrap(a, 0, l));
				}
			}
		} finally {
			if(ins != null)  ins.close();
		}
	}

}
