/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.delay;

import net.morilib.db.misc.Rational;

public class AvgDelay extends OneValueDelay {

	private Rational count, sum;

	public AvgDelay() {
		count = sum = Rational.ZERO;
	}

	public void add(Rational c) {
		sum = sum.add(c);
		count = count.add(Rational.ONE);
	}

	@Override
	public Object force() {
		return count.signum() > 0 ?
				sum.divide(count) : Rational.ZERO;
	}

}
