/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.delay.Delay;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;

public abstract class FnUnary extends RelationFunction {

	/* (non-Javadoc)
	 * @see net.morilib.db.relations.RelationFunction#isAggregate()
	 */
	@Override
	public final boolean isAggregate() {
		return false;
	}

	/**
	 * 
	 * @param a
	 * @return
	 */
	protected abstract Object operate(Object a);

	/**
	 * 
	 * @return
	 */
	protected abstract String getName();

	/* (non-Javadoc)
	 * @see net.morilib.db.relations.RelationFunction#operate(net.morilib.db.relations.RelationAggregate, java.util.List, java.lang.Object[])
	 */
	@Override
	public Object operate(RelationAggregate m, List<Object> group,
			final Object... args) throws SQLException {
		if(args.length != 1) {
			throw ErrorBundle.getDefault(10007, getName());
		} else if(args[0] instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return operate(((Delay)args[0]).force());
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)args[0]).add(args);
				}

			};
		} else {
			return operate(args[0]);
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.relations.RelationFunction#init(net.morilib.db.relations.RelationAggregate)
	 */
	@Override
	public final Object init() {
		return Rational.ZERO;
	}

}
