/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import net.morilib.db.jdbc.RelationsJDBCUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/08/11
 */
public final class ErrorBundle {

	private static RelationsLogger logger = RelationsJDBCUtils.logger;
	private static final ErrorBundle _DEF = getInstance(
			Locale.getDefault());

	private ResourceBundle bundle;

	private ErrorBundle(ResourceBundle b) {
		bundle = b;
	}

	/**
	 * 
	 * @return
	 */
	public synchronized static ErrorBundle getInstance(Locale locale) {
		ResourceBundle b;

		b = ResourceBundle.getBundle(
				"net/morilib/db/misc/relations_errors",
				locale);
		return new ErrorBundle(b);
	}

	/**
	 * 
	 * @param code
	 * @param mesg
	 * @return
	 */
	public String getMessage(int code, Object... mesg) {
		String s = bundle.getString(code + "");

		return s != null ? String.format(s, mesg) : s;
	}

	/**
	 * 
	 * @param code
	 * @param mesg
	 * @return
	 */
	public SQLException getException(int code, Object... mesg) {
		String s = getMessage(code, mesg);
		StringWriter t = new StringWriter();
		PrintWriter w = new PrintWriter(t);
		SQLException e;

		if(s != null) {
			s = String.format(s, mesg);
			e = new SQLException(s, null, code);
		} else {
			e = new SQLException(
					"unknown code: " + code,
					null,
					99999);
		}
		e.printStackTrace(w);
		w.flush();
		logger.finer(w.toString());
		return e;
	}

	/**
	 * 
	 * @param z
	 * @param mesg
	 * @return
	 */
	public SQLException getIOException(Throwable z, Object... mesg) {
		String s = getMessage(10037);
		StringWriter t = new StringWriter();
		PrintWriter w = new PrintWriter(t);
		SQLException e;

		s = String.format(s, mesg);
		e = new SQLException(s, null, 10037, z);
		e.printStackTrace(w);
		w.flush();
		logger.finer(t.toString());
		return e;
	}

	/**
	 * 
	 * @param code
	 * @param mesg
	 * @return
	 */
	public static String getDefaultMessage(int code, Object... mesg) {
		return _DEF.getMessage(code, mesg);
	}

	/**
	 * 
	 * @param code
	 * @param mesg
	 * @return
	 */
	public static SQLException getDefault(int code, Object... mesg) {
		return _DEF.getException(code, mesg);
	}

	/**
	 * 
	 * @param z
	 * @param mesg
	 * @return
	 */
	public static SQLException getIODefault(Throwable z,
			Object... mesg) {
		return _DEF.getIOException(z, mesg);
	}

}
