/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.morilib.parser.html.HTMLHandler;

public class HTMLTableHandler implements HTMLHandler {

	private static enum S {
		INIT, TABLE_P, TABLE, TR, TD, EXTRA
	}

	private List<List<String>> values;
	private List<String> value;
	private List<String> extra;
	private StringBuffer buf;
	private String name;
	private int tblno;
	private S stat;

	/**
	 * 
	 * @param n
	 */
	public HTMLTableHandler(String n) {
		values = new ArrayList<List<String>>();
		name = n;
		tblno = 0;
		stat = S.INIT;
	}

	public List<List<String>> getValues() {
		return Collections.unmodifiableList(values);
	}

	@Override
	public void string(String s) {
		if(stat != S.TD) {
			// do nothing
		} else {
			buf.append(s);
		}
	}

	@Override
	public void startTag(String s) {
		switch(stat) {
		case INIT:
			if(s.equalsIgnoreCase("TABLE")) {
				stat = S.TABLE_P;
				tblno++;
			}
			break;
		case TABLE_P:
			if(name.equalsIgnoreCase("TABLE" + tblno)) {
				stat = S.TABLE;
				// go next
			} else {
				break;
			}
		case TABLE:
			if(s.equalsIgnoreCase("TR")) {
				value = new ArrayList<String>();
				stat = S.TR;
			}
			break;
		case TR:
			if(s.equalsIgnoreCase("TD") ||
					s.equalsIgnoreCase("TH")) {
				buf = new StringBuffer();
				extra = new ArrayList<String>();
				extra.add(s);
				stat = S.TD;
			}
			break;
		case TD:
			if(s.equalsIgnoreCase(extra.get(0))) {
				value.add(buf.toString().trim());
				buf = new StringBuffer();
			} else if(s.equalsIgnoreCase("TR")) {
				value.add(buf.toString().trim());
				values.add(Collections.unmodifiableList(value));
				value = new ArrayList<String>();
				stat = S.TR;
			} else {
				buf.append('<').append(s).append(' ');
				extra.add(s);
				stat = S.EXTRA;
			}
			break;
		case EXTRA:
			extra.add(s);
			break;
		}
	}

	@Override
	public void endTag(String s) {
		switch(stat) {
		case INIT:
			break;
		case TABLE_P:
			stat = S.INIT;
			break;
		case TABLE:
			if(s.equalsIgnoreCase("TABLE")) {
				throw new HTMLTermException();
			}
			break;
		case TR:
			if(s.equalsIgnoreCase("TR")) {
				stat = S.TABLE;
				values.add(Collections.unmodifiableList(value));
			}
			break;
		case TD:
			if(s.equalsIgnoreCase(extra.get(0))) {
				stat = S.TR;
				value.add(buf.toString().trim());
			} else if(s.equalsIgnoreCase("TR")) {
				stat = S.TABLE;
				value.add(buf.toString().trim());
				values.add(Collections.unmodifiableList(value));
			}
			break;
		case EXTRA:
			while(extra.size() > 0 &&
					!extra.get(extra.size() - 1).equalsIgnoreCase(s)) {
				extra.remove(extra.size() - 1);
			}

			if(extra.size() > 1) {
				// do nothing
			} else if(extra.size() == 1) {
				value.add(buf.toString().trim());
				stat = S.TR;
			} else if(s.equalsIgnoreCase("TR")) {
				values.add(Collections.unmodifiableList(value));
				stat = S.TABLE;
			} else if(s.equalsIgnoreCase("TABLE")) {
				throw new HTMLTermException();
			}
			break;
		}
	}

	@Override
	public void tagAttribute(String k, String v) {
		switch(stat) {
		case INIT:  break;
		case TABLE_P:
			if(!k.equalsIgnoreCase("ID")) {
				// do nothing
			} else if(v.equalsIgnoreCase(name) ||
					name.equalsIgnoreCase("TABLE" + tblno)) {
				stat = S.TABLE;
			}
			break;
		case TABLE:  break;
		case TR:  break;
		case TD:  break;
		case EXTRA:  break;
		}
	}

	@Override
	public void meta(String s) {
		// do nothing
	}

	@Override
	public void comment(String s) {
		// do nothing
	}

}
