/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.ddl;

import java.sql.SQLException;

import net.morilib.db.misc.ErrorBundle;

public final class SqlTypeVarchar extends SqlColumnType {

	/**
	 * 
	 */
	public static final int UNLIMITED = 0;

	private int length;

	public SqlTypeVarchar(int l) {
		length = l;
	}

	@Override
	public int getLength() {
		return length;
	}

	@Override
	public int getScale() {
		return 0;
	}

	@Override
	public Object cast(String s) throws SQLException {
		return s;
	}

	@Override
	public String string(Object o) throws SQLException {
		String s = o.toString();

		if(length > 0 && s.length() > length) {
			throw ErrorBundle.getDefault(10044);
		} else {
			return s;
		}
	}

	@Override
	public int getSqlType() {
		return java.sql.Types.VARCHAR;
	}

	@Override
	public Class<?> getTypeClass() {
		return java.lang.String.class;
	}

	public int hashCode() {
		return length;
	}

	public boolean equals(Object o) {
		return (o instanceof SqlTypeVarchar &&
				((SqlTypeVarchar)o).length == length);
	}

	public String toString() {
		return "VARCHAR(" + length + ")";
	}

}
