/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public class HTTPRequest {

	private String method, path, version;
	private Map<String, String> headers =
			new LinkedHashMap<String, String>();
	private Map<String, String> parameters =
			new LinkedHashMap<String, String>();

	//
	HTTPRequest(String m, String a, String v, Map<String, String> h,
			Map<String, String> p) {
		method = m;
		path = a;
		version = v;
		headers = h;
		parameters = p;
	}

	/**
	 * @return the method
	 */
	public String getMethod() {
		return method;
	}

	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * @return the version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public String getHeader(String key) {
		return headers.get(key);
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public String getParameter(String key) {
		return parameters.get(key);
	}

	/**
	 * 
	 * @return
	 */
	public Map<String, String> getHeaders() {
		return Collections.unmodifiableMap(headers);
	}

	/**
	 * 
	 * @return
	 */
	public Map<String, String> getParameters() {
		return Collections.unmodifiableMap(parameters);
	}

}
