/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * ResourceCheckerPlugin NX
 */
public class ResourceCheckerPlugin extends AbstractUIPlugin {
	/** ResourceCheckerPluginID */
	public static final String ID = "jp.highwide.resourcechecker";
	/** ResourceCheckerPlugiñCX^X */
	private static ResourceCheckerPlugin instance;

	/**
	 * RXgN^B
	 */
	public ResourceCheckerPlugin() {
		instance = this;
	}

	/**
	 * CX^XԋpB
	 * @return ResourceCheckerPlugiñCX^X
	 */
	public static ResourceCheckerPlugin getInstance() {
		return instance;
	}

	/**
	 * Oo͂B
	 * @param e O
	 */
	public static void log(Throwable e) {
		instance.getLog().log(toIStatus(e));
	}
	/**
	 * Oo͂B
	 * @param status Xe[^X
	 */
	public static void log(IStatus status) {
		instance.getLog().log(status);
	}
	/**
	 * ThrowableIStatusɕϊB
	 * @param e Throwable
	 * @return IStatus
	 */
	private static IStatus toIStatus(Throwable e) {
		String message = e.getMessage();
		if (message == null) {
			message = "";
		}
		IStatus result = new Status(
				IStatus.ERROR,
				ResourceCheckerPlugin.ID,
				IStatus.ERROR,
				message,
				e);
		return result;
	}

	/**
	 * vOC̃ohJnsB
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	/**
	 * vOC̃oh~sB
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		instance = null;
	}
}
