/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.checker;

import java.util.HashMap;
import java.util.Map;


import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.texteditor.MarkerUtilities;

/**
 * ResourceCheckervOCŎgp}[J[̃NXB<br>
 * ResourceCheckerResulteclipseŗL̃}[J[Ƀf[^}bsOB
 */
public class ResourceCheckerMarker extends ResourceCheckerResult {
	/** }[J[ID */
	public static final String MARKER_ID = "jp.highwide.resourcechecker.resourcecheckermarker";
	/** }[J[̃Agr[g name */
	public static final String MARKER_ATTRIBUTE_NAME = "name";
	/** }[J[̃Agr[g userData */
	public static final String MARKER_ATTRIBUTE_USERDATA = "userData";

	private String name = "";

	/**
	 * ̃}[J[쐬B
	 */
	public ResourceCheckerMarker() {
	}

	/**
	 * ResourceCheckerResult}[J[쐬B
	 * @param resourceCheckResult 쐬ResourceCheckerResult
	 */
	public ResourceCheckerMarker(ResourceCheckerResult resourceCheckResult) {
		setName(resourceCheckResult.getLogicName());
		setLineNumber(resourceCheckResult.getLineNumber());
		setMessage(resourceCheckResult.getMessage());
		setSeverity(resourceCheckResult.getSeverity());
		setCharStart(resourceCheckResult.getCharStart());
		setCharEnd(resourceCheckResult.getCharEnd());
		setUserData(resourceCheckResult.getUserData());
	}

	/**
	 * }[J[̃Agr[gԋpB
	 * @return }[J[̃Agr[g
	 */
	public Map<String, Object> getAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		if (getCharStart() > -1) {
			MarkerUtilities.setCharStart(attributes, getCharStart());
			MarkerUtilities.setCharEnd(attributes, getCharEnd());
		}
		MarkerUtilities.setLineNumber(attributes, getLineNumber());
		MarkerUtilities.setMessage(attributes, getMessage());
		attributes.put(IMarker.SEVERITY, getSeverityInt());
		attributes.put(ResourceCheckerMarker.MARKER_ATTRIBUTE_NAME, getName());
		attributes.put(ResourceCheckerMarker.MARKER_ATTRIBUTE_USERDATA, getUserData());
		return attributes;
	}


	/**
	 * }[J[̏dvxԋpB
	 * @return }[J[̏dvx
	 */
	public Integer getSeverityInt() {
		switch (getSeverity()) {
		case SEVERITY_INFO:
			return IMarker.SEVERITY_INFO;
		case SEVERITY_WARNING:
			return IMarker.SEVERITY_WARNING;
		case SEVERITY_ERROR:
			return IMarker.SEVERITY_ERROR;
		}
		return -1;
	}

	/**
	 * }[J[̃bZ[WԋpB
	 * @return }[J[̃bZ[W
	 */
	@Override
	public String getMessage() {
		return "[" + getName() + "] " + super.getMessage();
	}

	/**
	 * }[J[̃Agr[g name ԋpB
	 * @return }[J[̃Agr[g name
	 */
	public String getName() {
		return name;
	}

	/**
	 * }[J[̃Agr[g name ݒ肷B
	 * @param name }[J[̃Agr[g name
	 */
	public void setName(String name) {
		this.name = name;
	}

}
