/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.property;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import jp.highwide.resourcechecker.ResourceCheckerPlugin;
import jp.highwide.resourcechecker.checker.ResourceCheckerLogic;
import jp.highwide.resourcechecker.dialog.ErrorDialog;
import jp.highwide.resourcechecker.widgets.CheckBoxListComposit;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/**
 * `FbNWbNNXݒ肷R|Wbg
 */
public class CheckLogicComposite extends CheckBoxListComposit {
	private Text checkerURIText;
	private Button updateButton;
	private Button checkAllButton;
	private Button uncheckAllButton;

	/**
	 * RXgN^B
	 * @param parent ẽR|Wbg
	 * @param title ^Cg
	 * @param checkerURIText WbNNXǂݍލۂURIi[ĂTextCX^X
	 */
	public CheckLogicComposite(Composite parent, String title,
			Text checkerURIText) {
		super(parent, title);
		this.checkerURIText = checkerURIText;
	}

	/**
	 * @see jp.highwide.resourcechecker.widgets.CheckBoxListComposit#createContents(java.lang.String)
	 */
	@Override
	protected void createContents(String title) {
		super.createContents(title);

		GridData gridData;
		gridData = new GridData();
		gridData.widthHint = 120;

		updateButton = new Button(this, SWT.NONE);
		updateButton.setText("JAR烍WbNǍ");
		updateButton.setLayoutData(gridData);
		updateButton.addSelectionListener(new SelectionAdapter() {
			/**
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent event) {
				final String uriStr = checkerURIText.getText();
				try {
					UpdateProgress op = new UpdateProgress(uriStr);
					new ProgressMonitorDialog(getShell()).run(true, true, op);

					if (op.getResult() == null) {
						ErrorDialog dialog = new ErrorDialog(
								getShell(),
								op.getException());
						dialog.open();
					} else {
						setValue(op.getResult());
					}

				} catch (InvocationTargetException e) {
					ResourceCheckerPlugin.log(e);
				} catch (InterruptedException e) {
					ResourceCheckerPlugin.log(e);
				}

			}
		});

		checkAllButton = new Button(this, SWT.NONE);
		checkAllButton.setText("SđI");
		checkAllButton.setLayoutData(gridData);
		checkAllButton.addSelectionListener(new SelectionAdapter() {
			/**
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent event) {
				TableItem[] items = getCheckBoxTable().getItems();
				for (TableItem item : items) {
					item.setChecked(true);
				}
			}
		});

		uncheckAllButton = new Button(this, SWT.NONE);
		uncheckAllButton.setText("ISĉ");
		uncheckAllButton.setLayoutData(gridData);
		uncheckAllButton.addSelectionListener(new SelectionAdapter() {
			/**
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent event) {
				TableItem[] items = getCheckBoxTable().getItems();
				for (TableItem item : items) {
					item.setChecked(false);
				}
			}
		});

	}

	/**
	 * JAR̒ResourceCheckerLogicNXB
	 */
	private class UpdateProgress implements IRunnableWithProgress {
		private static final String TMP_FILENAME = "resourcechecker.tmp.jar";
		private String uriStr = null;
		private String[] result = null;
		private Throwable exception = null;

		/**
		 * RXgN^B
		 * @param uriStr ResourceCheckerLogicNX܂jarURI
		 */
		public UpdateProgress(String uriStr) {
			this.uriStr = uriStr;
		}

		/**
		 * JAR̒ResourceCheckerLogicNXB
		 * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
		 */
		public void run(IProgressMonitor monitor)
				throws InvocationTargetException, InterruptedException {
			monitor.beginTask("`FbNWbN̍XVn߂܂B", 2);
			File tmpFile = null;
			try {
				monitor.subTask("jart@C擾");
				URL url = new URI(uriStr).toURL();
				// TODO vLVΉ
				URLConnection con = url.openConnection();
				tmpFile = new File(TMP_FILENAME);
				FileOutputStream fos = null;
				BufferedInputStream bis = null;
				try {
					fos = new FileOutputStream(tmpFile);
					bis = new BufferedInputStream(con.getInputStream());
					int b = -1;
					while ((b = bis.read()) != -1) {
						fos.write(b);
						if (Thread.interrupted()) {
							throw new InterruptedException();
						}
					}
					fos.flush();
				} finally {
					if (bis != null) {
						bis.close();
					}
					if (fos != null) {
						fos.close();
					}
					monitor.worked(1);
				}

				monitor.subTask("NX");
				ArrayList<String> classNameList = new ArrayList<String>();
				JarFile jarFile = new JarFile(tmpFile);
				for (Enumeration en = jarFile.entries(); en.hasMoreElements();) {
					JarEntry entry = (JarEntry) en.nextElement();
					// Ci[NX͊܂߂Ȃ
					if (entry.getName().matches("[\\w/\\.]+\\.class$")) {
						String className = entry.getName();
						className = className.replaceAll("/", ".");
						className = className.replaceAll("\\.class", "");
						classNameList.add(className);
					}
				}
				jarFile.close();

				ArrayList<String> logicClassNameList = new ArrayList<String>();
				ClassLoader parent = Thread.currentThread().getContextClassLoader();
				URLClassLoader loader = new URLClassLoader(
						new URL[]{url},
						parent);
				for (String checkClass : classNameList) {
					Object checkObject = null;
					try {
						Class c = loader.loadClass(checkClass);
						checkObject = c.newInstance();
					} catch (Exception e) {
					}
					if (checkObject instanceof ResourceCheckerLogic) {
						logicClassNameList.add(checkClass);
					}
				}
				loader = null;
				System.gc();

				result = (String[]) logicClassNameList.toArray(new String[0]);
				monitor.worked(1);
			} catch (MalformedURLException e) {
				exception = e;
			} catch (URISyntaxException e) {
				exception = e;
			} catch (IOException e) {
				exception = e;
			} finally {
				if (tmpFile != null) {
					tmpFile.delete();
				}
				monitor.done();
			}
		}

		/**
		 * ʂԋpB
		 * @return ResourceCheckerLogicNẌꗗ
		 */
		public String[] getResult() {
			return result;
		}

		/**
		 * Ɏsۂ̗OԋpB
		 * @return Ɏsۂ̗OBĂꍇnull
		 */
		public Throwable getException() {
			return exception;
		}

	}

}
