/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.widgets;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * `FbN{bNXt̃XgR|WbgB
 * e[ủɂ͕ҏWp(ǉAύXA폜)̃{^t
 */
public class CheckBoxListEditComposit extends CheckBoxListComposit {
	private Button addButton;

	private Button editButton;

	private Button removeButton;

	private static final String addButtonTitle = "ǉ";

	private static final String editButtonTitle = "ύX";

	private static final String removeButtonTitle = "폜";

	private String defaultInputValue = "";

	/**
	 * RXgN^B
	 * @param parent ẽR|Wbg
	 * @param title ^Cg
	 */
	public CheckBoxListEditComposit(Composite parent, String title) {
		super(parent, title);
	}

	/**
	 * R|Wbg̏sB
	 * e[ủɕҏWp(ǉAύXA폜)̃{^zu
	 * @see jp.highwide.resourcechecker.widgets.CheckBoxListComposit#createContents(java.lang.String)
	 */
	@Override
	protected void createContents(String title) {
		super.createContents(title);

		// ǉ button
		addButton = new Button(this, SWT.NONE);
		addButton.setText(addButtonTitle);
		GridData gridData = new GridData();
		gridData.widthHint = 50;
		gridData.horizontalAlignment = SWT.BEGINNING;
		addButton.setLayoutData(gridData);
		addButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				addItemAction();
			}
		});

		// ύX button
		editButton = new Button(this, SWT.NONE);
		editButton.setText(editButtonTitle);
		editButton.setLayoutData(gridData);
		editButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				editItemAction();
			}
		});
		getCheckBoxTable().addMouseListener(new MouseListener() {
			public void mouseDoubleClick(MouseEvent e) {
				editItemAction();
			}

			public void mouseDown(MouseEvent e) {
			}

			public void mouseUp(MouseEvent e) {
			}
		});

		// 폜 button
		removeButton = new Button(this, SWT.NONE);
		removeButton.setText(removeButtonTitle);
		removeButton.setLayoutData(gridData);
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				deleteItemAction();
			}
		});
	}

	/**
	 * uǉvsꂽƂɓ삷郁\bhB<p>
	 * <code>setDefaultInputValue</code>\bhŐݒ肳ꂽftHgl
	 * InputDialog\AXgɒǉB<br>
	 * prɉOverrideė֐邱Ƃ\B
	 */
	protected void addItemAction() {
		InputDialog input = new InputDialog(addButton.getShell(),
				addButtonTitle,
				addButtonTitle,
				defaultInputValue,
				null);
		int code = input.open();
		if (code == InputDialog.CANCEL) {
			return;
		}
		addValue(input.getValue(), true);
		defaultInputValue = input.getValue();
	}

	/**
	 * uύXvsꂽƂɓ삷郁\bhB<p>
	 * IꂽXgftHglƂ
	 * InputDialog\AXg̒lύXB<br>
	 * XgACẽ_uNbNR[obNB<br>
	 * prɉOverrideė֐邱Ƃ\B
	 */
	protected void editItemAction() {
		int index = getCheckBoxTable().getSelectionIndex();
		if (index < 0) {
			return;
		}
		String text = getCheckBoxTable().getItem(index).getText();
		InputDialog input = new InputDialog(editButton.getShell(),
				editButtonTitle,
				editButtonTitle,
				text,
				null);
		int code = input.open();
		if (code == InputDialog.CANCEL) {
			return;
		}
		changeValue(index, input.getValue());
		defaultInputValue = input.getValue();
	}

	/**
	 * u폜vsꂽƂɓ삷郁\bhB<p>
	 * IꂽXg폜B<br>
	 * prɉOverrideė֐邱Ƃ\B
	 */
	protected void deleteItemAction() {
		int index = getCheckBoxTable().getSelectionIndex();
		if (index < 0) {
			return;
		}
		getCheckBoxTable().remove(index);
	}

	/**
	 * defaultInputValueԋpB
	 * @return defaultInputValue defaultInputValue
	 */
	protected String getDefaultInputValue() {
		return defaultInputValue;
	}

	/**
	 * defaultInputValueݒ肷B
	 * @param defaultInputValue defaultInputValue
	 */
	protected void setDefaultInputValue(String defaultInputValue) {
		this.defaultInputValue = defaultInputValue;
	}

	/**
	 * addButtonTitleԋpB
	 * @return addButtonTitle addButtonTitle
	 */
	protected static String getAddButtonTitle() {
		return addButtonTitle;
	}

	/**
	 * editButtonTitleԋpB
	 * @return editButtonTitle editButtonTitle
	 */
	protected static String getEditButtonTitle() {
		return editButtonTitle;
	}

	/**
	 * removeButtonTitleԋpB
	 * @return removeButtonTitle removeButtonTitle
	 */
	protected static String getRemoveButtonTitle() {
		return removeButtonTitle;
	}

}