/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.widgets;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/**
 * O\CompositeNXB
 */
public class StacktraceComposit extends Composite {
	private FormToolkit toolkit;
	private Form form;

	/**
	 * RXgN^B
	 * @param parent eComposite
	 * @param e \O
	 */
	public StacktraceComposit(Composite parent, Throwable e) {
		this(parent, SWT.NONE, e);
	}
	/**
	 * RXgN^B
	 * @param parent eComposite
	 * @param style widgets̃X^C
	 * @param e \O
	 */
	public StacktraceComposit(Composite parent, int style, Throwable e) {
		super(parent, style);
		createOwnWidget(e);
	}
	private void createOwnWidget(Throwable e) {
		this.setLayout(new FillLayout());
		toolkit = new FormToolkit(this.getDisplay());
		form = toolkit.createForm(this);
		form.setText("R:" + e.getMessage());
		form.getBody().setLayout(new TableWrapLayout());
		createStacktracePanel(form.getBody(), e);
	}

	private static String toStringStackTrace(Throwable e) {
		StringWriter stringWriter = new StringWriter();
		PrintWriter printWriter = new PrintWriter(stringWriter);
		e.printStackTrace(printWriter);
		return stringWriter.toString();
	}
	private void createStacktracePanel(Composite parent, Throwable e) {
		Section section = createSection(toolkit, parent);
		section.setText("X^bNg[X ...");
		Composite panel = (Composite) section.getClient();
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginHeight = 5;
		panel.setLayout(gridLayout);

		toolkit.setBorderStyle(SWT.NONE);
		Text fText = toolkit.createText(panel, toStringStackTrace(e), SWT.MULTI
				| SWT.READ_ONLY | SWT.WRAP | SWT.NONE);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		fText.setLayoutData(gridData);
		gridData.widthHint = 450;

	}
	private Section createSection(FormToolkit toolkit, Composite parent) {
		return createSection(toolkit, parent, ExpandableComposite.TWISTIE);
	}

	private Section createSection(FormToolkit toolkit,
			Composite parent,
			int style) {
		Section section = toolkit.createSection(parent, style);
		TableWrapData td = new TableWrapData();
		td.align = TableWrapData.FILL;
		td.grabHorizontal = true;
		section.setLayoutData(td);
		toolkit.createCompositeSeparator(section);
		section.setClient(toolkit.createComposite(section));
		return section;
	}

}
