<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilOci8.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Column.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class ExtDbUtilOci8 extends DbUtilOci8{	
	function forward($tagDataProjectDatabase){
		$sql			= "";
		$defaultSql	= "";
		$seqSql			= "";
		
		if(Variable::isClassType(DatabaseModel,$tagDataProjectDatabase)){
			foreach($tagDataProjectDatabase->tableList as $table){
				if(Variable::isClassType(TableModel,$table)){
					$sql			.= sprintf("CREATE TABLE %s (",$table->getTableName());
					$columnSql	= "";
					$primarySql	= "";
					
					foreach($table->columnList as $column){
						if(Variable::isClassType(ColumnModel,$column)){
							if(!empty($columnSql)){
								$columnSql .= "\t,";
							}
							$columnSql .= sprintf("\"%s\"",$column->name);
							
							if(preg_match("/(serial)/i",$column->type)){
								$columnSql .= sprintf(" NUMBER");
							}else if(preg_match("/(float)/i",$column->type)){
								$columnSql .= sprintf(" FLOAT");
							}else if(preg_match("/(timestamp)|(date)/i",$column->type)){
								$columnSql .= sprintf(" DATE");
							}else if(preg_match("/(int)|(time)/i",$column->type)){
								$columnSql .= sprintf(" NUMBER");

								if($column->size > 0){
									$columnSql .= sprintf("(%d)",$column->size);
								}
							}else if(preg_match("/(string)|(text)|(email)|(tel)|(zip)/i",$column->type)){
								if($column->size > 0 && $column->size < 255){
									$columnSql .= sprintf(" NVARCHAR2");
									$columnSql .= sprintf("(%d)",$column->size);
								}else{
									$columnSql .= sprintf(" NVARCHAR2");
								}
							}else if(preg_match("/(bool)/i",$column->type)){
								$columnSql .= sprintf(" NUMBER(1)");
							}
							if($column->require){
								$columnSql .= sprintf(" NOT NULL");
							}
							if($column->default != ""){
								$default = "";

								if(preg_match("/(timestamp)|(date)/i",$column->type)){
									if(!preg_match("/sysdate/i",$column->default)){
										$default = sprintf("'%s'",$column->default);
									}
								}else if(preg_match("/(string)|(text)|(email)|(time)|(tel)|(zip)/i",$column->type) && $column->size < 255){
									$default = sprintf("'%s'",$column->default);
								}else if(preg_match("/(bool)/i",$column->type)){
									$default = sprintf("%d",intval(Variable::getBoolean($column->default)));									
								}else{
									$default = sprintf("%s",$column->default);
								}
								if($default != ""){
									$columnSql .= sprintf(" DEFAULT %s",$default);
								}
							}
						}
						if(preg_match("/(serial)/i",$column->type)){
							$seqSql .= $this->_createSequenceTrigger($column->name,$table->getTableName());
						}
					}
					foreach($table->primaryList as $column){
						if(!empty($primarySql)){
							$primarySql .= ",";
						}
						$primarySql .= sprintf("\"%s\"",$column->name);
					}
					$sql	 .= sprintf("\t %s",$columnSql);
					if(!empty($primarySql)){
						$sql .= sprintf("\t,CONSTRAINT %s PRIMARY KEY(%s)",sprintf("%s_PK",$table->getTableName()),$primarySql);
					}
					$sql .= sprintf(");\n");

					foreach($table->defaultList as $defaults){
						$columnString	= "";
						$valueString		= "";		
						
						foreach($table->columnList as $column){
							if($column->type != "SERIAL"){
								$value = $column->default;
	
								foreach($defaults as $default){
									if($default->column == $column->name){
										$value = $default->value;
										break;
									}
								}
								$value = $this->_getValueString($column,$value);

								$columnString	.= sprintf(",%s",$column->name);
								$valueString		.= sprintf(",%s",$value);
							}
						}
						$defaultSql .= sprintf("insert into %s(%s) values(%s);\n",$table->getTableName(),substr($columnString,1),substr($valueString,1));
					}
				}
			}
			foreach($tagDataProjectDatabase->tableList as $table){
				if(Variable::isClassType(TableModel,$table)){
					foreach($table->referenceList as $reference){
						$sql .= sprintf("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);\n",
													$reference->table,
													sprintf("FK_%s_%s",$reference->table,$reference->column),
													$reference->column,
													$reference->referenceTableReal,
													$reference->referenceColumn
									);
					}
				}
			}
			$sql = sprintf("%s%s%s",$sql,$seqSql,$defaultSql);
		}
		return $sql;
	}
	function _createSequenceTrigger($serialName,$tableName){
		$sql = "";

		$sql .= sprintf("create sequence \"%s_%s_sq\"",$tableName,$serialName);
		$sql .= sprintf(" increment by 1");
		$sql .= sprintf(" start with 1");
		$sql .= sprintf(" nomaxvalue");
		$sql .= sprintf(" nominvalue");		
		$sql .= sprintf(" nocycle");
		$sql .= sprintf(" cache 20");
		$sql .= sprintf(" noorder");
		$sql .= sprintf(";");
		$sql .= sprintf("\n");

		return $sql;		
	}
}
?>