<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Http.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/Cache.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.4.1
 */
class TagParser{
	var $variables		= array();
	var $fileName		= "";
	var $_executeMethod	= array();

	function TagParser($filename=null){
		$this->setFileName($filename);
	}
	function write($templateFileName="",$remotePath="",$variables=array()){
		print(StringUtil::encoding($this->read($templateFileName,$remotePath,$variables)));
	}
	function read($filename="",$remotePath="",$variables=array()){
		$this->fileName	= empty($filename) ? $filename = $this->fileName : $filename;
		$filename		= Rhaco::templatepath($this->fileName);
		$variables		= $this->_setSpecialVariables(array_merge(Variable::toArray($variables),Variable::toArray($this->variables)));
		$cacheurl		= $this->_getCacheUrl($filename);
		$remotePath		= Rhaco::templateurl($remotePath);

		if(!Variable::getBoolean(Rhaco::define("NOT_MAKE_CACHE")) &&
			Variable::getBoolean(Rhaco::define("TEMPLATE_CACHE")) && !Cache::isExpiry($cacheurl,Rhaco::define("TEMPLATE_CACHE_TIME",86400)) &&
			(!Variable::getBoolean(Rhaco::define("TEMPLATE_CACHE_REFRESH")) || FileUtil::getUpdateTime($filename) < Cache::getUpdateTime($cacheurl))
		){
			$src = Cache::execute($cacheurl,$variables);
		}else{
			$readsrc = $this->parse($filename,$remotePath);

			if(Variable::getBoolean(Rhaco::define("TEMPLATE_CACHE")) && !Variable::getBoolean(Rhaco::define("NOT_MAKE_CACHE"))){
				Cache::set($cacheurl,$readsrc);
			}
			foreach($variables as $key => $variable){
				global ${$key};
				${$key} = $variable;
			}
			ob_start();
				eval("?>".$readsrc);
				$src = ob_get_contents();
			ob_end_clean();
		}
		return $this->_call($src,"_doRead");
	}
	function parse($templateFileName,$remotePath=""){	
		$src = $this->_getTemplateSource($templateFileName);
		$src = $this->_call($src,"_system");
		$src = $this->_call($src,"_toTag");
		$src = $this->_call($src,"_exec");
		$src = $this->_parsePrintVariable($src);
		$src = $this->_parseMessage($src);
		$src = Url::parse($src,$remotePath);

		return $this->_escapeSource($src);
	}
	function setVariable($arrayOrKey,$value=""){
		if(!is_array($arrayOrKey)){
			$arrayOrKey = array($arrayOrKey=>$value);
		}
		foreach($arrayOrKey as $key => $value){
			$this->variables[$key] = $value;
		}
	}
	function clearVariable(){
		if(func_num_args() == 0){
			$this->variables = array();
		}else{
			foreach(func_get_args() as $name){
				unset($this->variables[$name]);
			}
		}
	}	
	function setFileName($value){
		$this->fileName = $value;
	}
	function _parseMessage($src){
		if(preg_match_all("/.{0,2}(_\((([\"\']).+?\\3)\))/",$src,$matches)){
			$stringList		= array();

			foreach($matches[0] as $key => $value){
				$chkstring = substr($value,0,2);
				if($chkstring != "::" && $chkstring != "->"){
					$stringList[$matches[1][$key]] = sprintf("<?php print(\$message->_(%s)); ?>",$matches[2][$key]);
				}
			}
			foreach($stringList as $baseString => $string){
				$src = str_replace($baseString,$string,$src);
			}
			unset($stringList);
		}
		return $src;
	}
	function _escapeSource($src){
		if(preg_match_all("/<\?([\w\d]+)/",$src,$null)){
			foreach($null[1] as $value){
				if(strtolower($value) != "php"){
					$src = str_replace(sprintf("<?%s",$value),sprintf("__PHP_TAG_ESCAPE__%s",$value),$src);
				}
			}
		}
		return $src;
	}
	function _doRead0001_UnescapeSource($src){
		return str_replace("__PHP_TAG_ESCAPE__","<?",$src);
	}
	function _getPhpTagStart(){
		return "<?php ";
	}
	function _getPhpTagEnd(){
		return " ?>";
	}
	function _call($src,$runmethod){
		if(!isset($this->_runmethod[$runmethod]) || empty($this->_runmethod[$runmethod])){
			$this->_runmethod[$runmethod] = array();
			
			foreach(get_class_methods($this) as $methodName){
				if(preg_match("/^".$runmethod."(.+)$/i",$methodName)){
					$this->_runmethod[$runmethod][] = $methodName;
				}
			}
			sort($this->_runmethod[$runmethod]);
		}
		foreach(Variable::toArray($this->_runmethod[$runmethod]) as $methodName){
			$src = call_user_func_array(array($this, $methodName),array($src));		
		}
		return $src;
	}
	function _parsePrintVariable($src){
		foreach($this->_matchVariable($src) as $variable){
			$name	= $this->_parsePlainVariable($variable);
			$src		= str_replace($variable,$this->_getPhpTagStart()."print(".$name.");".$this->_getPhpTagEnd(),$src);
		}
		return $src;
	}
	function _toVariable($src){
		if(!preg_match("/^\{\$.+\}$/",$src)){
			return sprintf("{\$%s}",$src);
		}
		return $src;
	}
	function _parsePlainVariable($src){
		while(true){
			$array = $this->_matchVariable($src);
			
			if(sizeof($array) <= 0){
				break;
			}
			foreach($array as $variable){
				$variable_tmp = $variable;
				
				if(preg_match_all("/([\"\'])([^\\1]+)\\1/",$variable,$matches)){
					foreach($matches[2] as $value){
						$variable_tmp = str_replace($value,str_replace(".","__PERIOD__",$value),$variable_tmp);
					}
				}
				$src = str_replace($variable,str_replace(".","->",substr($variable_tmp,1,-1)),$src);
			}
		}
		unset($array,$variable,$matches,$variable_tmp);
		return str_replace("__PERIOD__",".",$src);
	}
	function _matchVariable($src){
		$value			= "";
		$position		= 0;
		$length			= 0;
		$variableHash	= array();
		$variables		= array();

		while(preg_match("/({(\\$\w[^\t]+)})/s",$src,$variables,PREG_OFFSET_CAPTURE)){
			$value		= $variables[1][0];
			$position	= $variables[1][1];

			if($value == ""){	break;	}
			if(substr_count($value,"}") > 1){
				for($i=0,$start=0,$end=0;$i<strlen($value);$i++){			
					if($value[$i] == "{"){
						$start++;
					}else if($value[$i] == "}"){
						if($start == ++$end){	
							$value = substr($value,0,$i+1);
							break;
						}
					}
				}
			}
			$length	= strlen($value);			
			$src		= substr($src,$position + $length);
			$variableHash[sprintf("%03d_%s",$length,$value)] = $value;
		}
		krsort($variableHash);
		unset($src,$variables,$value,$position,$length);
		return $variableHash;
	}
	function _variableQuote($src){
		return preg_replace("/[^\w\d]/","",$src);
	}
	function _getVariableString($src){
		if(substr($src,0,1) == "$"){
			return $src;
		}
		return "\$".$src;
	}
	function _setSpecialVariables($variables){
		$variables["variables"]	= $variables;
		$variables["message"]		= new Message();
		$variables["rhaco"]		= new Rhaco();
		$variables["exceptions"]	= ExceptionTrigger::get();
		
		return $variables;
	}
	function _getTemplateSource($templateFileName){
		$src = preg_match("/[\w]+:\/\/[\w]+/",$templateFileName) ? Http::body($templateFileName) : File::read($templateFileName);
		return StringUtil::encoding($src);
	}
	function _getCacheUrl($templateFileName){
		return $templateFileName;
	}
}
?>