<?php
Rhaco::import("network.http.data.RequestLoginCondition");
Rhaco::import("network.http.Request");
Rhaco::import("network.http.Header");
Rhaco::import("lang.DateUtil");
Rhaco::import("database.data.Criteria");
Rhaco::importLibrary("data.UserLogin");
Rhaco::importLibrary("data.UserDetail");
Rhaco::importLibrary("data.Memory");
Rhaco::importLibrary("UserController");
Rhaco::importLibrary("DbUtilGoesby");

class LoginCondition extends RequestLoginCondition{
	function condition($request){
		$user		= $request->toObject(new UserLogin());	
		$dbUtil		= DbUtilGoesby::instance();
		$criteria	= new Criteria(UserLogin::columnLogin(),$user->getLogin());
		$criteria->add(UserLogin::columnPassword(),$user->getEncodePassword());
		$criteria->addJoin(UserLogin::columnId(),UserDetail::columnUserId());				

		list(list($user),list($userDetail)) = $dbUtil->select(array(new UserLogin(),new UserDetail()),$criteria);

		if(!Variable::isClassType(UserLogin,$user)){
			return false;
		}
		$userDetail->setUser($user);
		RequestLogin::setLoginSession($userDetail);
		return true;
	}
	function invalid($request){
		unset($request);
	}
	function after(){
		$userDetail	= RequestLogin::getLoginSession();

		if(Variable::isClassType(UserDetail,$userDetail)){
			$dbUtil		= DbUtilGoesby::instance();
			$user		= $dbUtil->get(new UserLogin($userDetail->getUserId()));			

			if(Variable::isClassType(UserLogin,$user) &&
				(!RequestLogin::isLoginCookie() || $user->getCode() != RequestLogin::getLoginCookie())
			){
				if($user->getCode() != ""){
					$uniq = $user->getCode();
				}else{
					$uniq = uniqid($user->getId()."LOGIN");
				}
				RequestLogin::setLoginCookie($uniq);
				$user->setCode($uniq);				
				$dbUtil->update($user);
			}
			if(Variable::isClassType(UserDetail,$userDetail)){
				$userDetail->setLastLoginDate(time());
				$dbUtil->update($userDetail);
			}
			$criteria = new Criteria();
			$criteria->addLess(Memory::columnRegistDate(),DateUtil::addDay(time(),Rhaco::define("MEMORY_LIMIT",1)*-1));
			$dbUtil->delete(new Memory(),$criteria);
			$dbUtil->commit();
		}
	}
}
?>