<?php
class Query{
	var $keyword;
	var $rssTime;
	var $limit;
	var $offset;
	var $tags;
	
	function Query($tags=null){
		$this->setTags($tags);
	}	
	function setKeyword($value){
		$this->keyword = $value;
	}
	function isKeyword(){
		return !empty($this->keyword);
	}
	function getKeywords(){
		$list = array();
		
		if($this->isKeyword()){
			$keywords = split(" ",str_replace("　"," ",$this->keyword));
			
			foreach($keywords as $keyword){
				if(!empty($keyword)){
					$list[] = sprintf(".*%s.*",$keyword);
				}
			}
		}
		return $list;
	}
	function addIds($id){
		$this->ids[] = intval($id);
	}
	function isIds(){
		return (sizeof($this->ids) > 0);
	}
	function isRssTime(){
		return !empty($this->rssTime);
	}
	function setRssTime($value){
		$this->rssTime = intval($value);
	}
	function getRssTime(){
		return $this->rssTime;
	}
	function setLimit($value){
		$this->limit = intval($value);
	}
	function getLimit(){
		return $this->limit;
	}
	function isLimit(){
		return (intval($this->limit) > 0);
	}
	function setOffset($value){
		$this->offset = intval($value);
	}
	function getOffset(){
		return $this->offset;
	}
	function setTags($list){
		$this->tags = array();

		foreach(Variable::toArray($list) as $tag){
			if(!empty($tag)){
				$this->tags[] = sprintf(".*%s.*",$tag);
			}
		}
		return $this->tags;
	}
	function getTags(){
		return $this->tags;
	}
}
?>