<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.FeedVerify");
Rhaco::importLibrary("data.PageFeed");
Rhaco::importLibrary("data.Item");
class FeedTable extends TableObjectBase{
	var $id;
	var $url;
	var $updateDate;
	function FeedTable(
		$id=null
	){
		$this->id = 0;
		$this->url = null;
		$this->updateDate = null;
		$this->setId($id);
	}
	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setUrl($value){
		$this->url = $value;
	}
	function getUrl(){
		return $this->url;
	}
	function setUpdateDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->updateDate = $value;
	}
	function getUpdateDate(){
		return $this->updateDate;
	}
	function formatUpdateDate($format="Y/m/d H:i:s"){
		return date($format,$this->updateDate);
	}
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."FEED","FEED"),"ID","Id","SERIAL");
	}
	function columnUrl(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."FEED","FEED"),"URL","Url","STRING");
	}
	function columnUpdateDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."FEED","FEED"),"UPDATE_DATE","UpdateDate","TIMESTAMP");
	}
	function dependColumnId(){
		return array(
				array(new PageFeed(),new Item(),),
				array(PageFeed::columnFeedId(),Item::columnFeedId(),),
				$this->getId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new FeedVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
			list($objList,$columnList,$value) = $this->dependColumnId();
			foreach($objList as $key => $obj){
				$dbUtil->delete($obj,new Criteria($columnList[$key],$value));
			}
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new FeedVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(Feed::columnId(),Feed::columnUrl(),Feed::columnUpdateDate(),);
	}
	function primaryKey(){
		return array(Feed::columnId(),);
	}
}
?>