<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class ItemTableVerify{
	var $valid = true;

	function ItemTableVerify(){
	}
	function verify($tableObject){
		$this->verifyId($tableObject->getId());
		$this->verifyFeedId($tableObject->getFeedId());
		$this->verifyUrl($tableObject->getUrl());
		$this->verifyTitle($tableObject->getTitle());
		$this->verifyDescription($tableObject->getDescription());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		return $this->valid;	
	}
	function verifyId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedId())),$this->_validName("id"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedId())),$this->_validName("id"));
		}
		unset($value);
	}
	function verifyFeedId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedFeedId())),$this->_validName("feedId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedFeedId())),$this->_validName("feedId"));
		}
		unset($value);
	}
	function verifyUrl($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUrl())),$this->_validName("url"));
		}
		if(!empty($value) && !Validate::isString($value,0,2000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedUrl(),2000)),$this->_validName("url"));
		}
		unset($value);
	}
	function verifyTitle($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedTitle())),$this->_validName("title"));
		}
		if(!empty($value) && !Validate::isString($value,0,1000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTitle(),1000)),$this->_validName("title"));
		}
		unset($value);
	}
	function verifyDescription($value){
		if(!empty($value) && !Validate::isString($value,0,6000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedDescription(),6000)),$this->_validName("description"));
		}
		unset($value);
	}
	function verifyUpdateDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedUpdateDate())),$this->_validName("updateDate"));
		}
		unset($value);
	}

	function namedId(){
		return Message::_("ID");
	}
	function namedFeedId(){
		return Message::_("FEED_ID");
	}
	function namedUrl(){
		return Message::_("URL");
	}
	function namedTitle(){
		return Message::_("TITLE");
	}
	function namedDescription(){
		return Message::_("DESCRIPTION");
	}
	function namedUpdateDate(){
		return Message::_("UPDATE_DATE");
	}
	function _validName($name){
		$this->valid = false;
		return "Item_".$name;
	}
}

?>