<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.UserDetailVerify");
Rhaco::importLibrary("data.UserLogin");
class UserDetailTable extends TableObjectBase{
	var $userId;
	var $url;
	var $comment;
	var $registDate;
	var $lastLoginDate;
	var $tags;
	var $bookmarkCount;
	function UserDetailTable(
		$userId=null
	){
		$this->userId = 0;
		$this->url = null;
		$this->comment = null;
		$this->registDate = time();
		$this->lastLoginDate = null;
		$this->tags = null;
		$this->bookmarkCount = 0;
		$this->setUserId($userId);
	}
	function setUserId($value){
		$this->userId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getUserId(){
		return $this->userId;
	}
	function setUrl($value){
		$this->url = $value;
	}
	function getUrl(){
		return $this->url;
	}
	function setComment($value){
		$this->comment = $value;
	}
	function getComment(){
		return $this->comment;
	}
	function setRegistDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->registDate = $value;
	}
	function getRegistDate(){
		return $this->registDate;
	}
	function formatRegistDate($format="Y/m/d"){
		return date($format,$this->registDate);
	}
	function setLastLoginDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->lastLoginDate = $value;
	}
	function getLastLoginDate(){
		return $this->lastLoginDate;
	}
	function formatLastLoginDate($format="Y/m/d H:i:s"){
		return date($format,$this->lastLoginDate);
	}
	function setTags($value){
		$this->tags = $value;
	}
	function getTags(){
		return $this->tags;
	}
	function setBookmarkCount($value){
		$this->bookmarkCount = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getBookmarkCount(){
		return $this->bookmarkCount;
	}
	function columnUserId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"USER_ID","UserId","INTEGER");
	}
	function columnUrl(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"URL","Url","STRING");
	}
	function columnComment(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"COMMENT","Comment","STRING");
	}
	function columnRegistDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"REGIST_DATE","RegistDate","DATE");
	}
	function columnLastLoginDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"LAST_LOGIN_DATE","LastLoginDate","TIMESTAMP");
	}
	function columnTags(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"TAGS","Tags","STRING");
	}
	function columnBookmarkCount(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_DETAIL","USER_DETAIL"),"BOOKMARK_COUNT","BookmarkCount","INTEGER");
	}
	function referenceUserId(){
		return array(new UserLogin(),UserLogin::columnId(),$this->getUserId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			UserLogin::columnId(),
			UserDetail::columnUserId()
		);
		return $criteria;
	}
	function criteriaUserId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			UserLogin::columnId(),
			$this->getUserId()
		);
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new UserDetailVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new UserDetailVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(UserDetail::columnUserId(),UserDetail::columnUrl(),UserDetail::columnComment(),UserDetail::columnRegistDate(),UserDetail::columnLastLoginDate(),UserDetail::columnTags(),UserDetail::columnBookmarkCount(),);
	}
	function primaryKey(){
		return array(UserDetail::columnUserId(),);
	}
}
?>