/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import jp.co.nri.ridual.r2.common.html.HtmlNodes;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.db.bean.project.FormTagFilterMap;
import jp.co.nri.ridual.r2.db.bean.project.ObjectTagFilterMap;
import jp.co.nri.ridual.r2.db.dao.HtmlNodesDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlNodeBean
extends AbstractProjectNodable
implements HtmlNodes {
    public static final String HQL_QUERY_NAME_FIND_NODE_BY_TYPE_AND_NAME = "htmlNode.findNodeByTypeAndName";
    public static final String HQL_QUERY_NAME_FIND_NODE_BY_PARENT_AND_TYPE = "htmlNode.findNodeByParentId";
    public static final String HQL_QUERY_NAME_DELETE_NODE_BY_VARIATION_ID = "htmlNode.deleteNodeByVariationId";
    public static final String HQL_QUERY_NAME_FIND_ATTRIBUTE_BY_VARIATION_ID = "htmlNode.findAttributesByVariationId";
    public static final String HQL_QUERY_NAME_FIND_ROOT = "htmlNode.findRoot";
    public static final String HQL_QUERY_NAME_COUNT_BY_FLAG = "htmlNode.countByFlag";
    public static final String HQL_QUERY_NAME_COUNT_TAG_BY_NAME = "htmlNode.countTagByName";
    public static final String HQL_QUERY_NAME_FIND_NODE_BY_PARENT_AND_TYPE_NAME = "htmlNode.findNodeByParentIdAndName";
    public static final String HQL_QUERY_NAME_FIND_ATTRIBUTES_BY_VARIATION_ID_FOR_SCRIPT = "htmlNode.findAttributesByVariationIdForScript";
    public static final String HQL_QUERY_NAME_FIND_NODE_BY_TYPE = "htmlNode.findNodeByType";
    public static final String HQL_QUERY_NAME_FIND_NODE_BY_NAME = "htmlNode.findNodeByName";
    private static final String ELEMENT_NAME_ROOT = "HTML_ELEMENT";
    private static final String ELEMENT_NAME_ATTRIBUTE = "HTML_ATTRIBUTE";
    private static final String ELEMENT_NAME_TEXT = "HTML_TEXT";
    private static final String ELEMENT_NAME_NAME = "NAME";
    private static final String ELEMENT_NAME_VALUE = "VALUE";
    private static final String ELEMENT_NAME_FLAG = "FLAG";
    private Integer id;
    private Integer contentsId;
    private Integer variationId;
    private Integer parentId;
    private String name;
    private String value;
    private int type;
    private String flag;
    private Boolean includedHalfKana = null;
    private Boolean includedWrongChar = null;

    public Node buildNode(Integer projectId, int mode, Document doc) throws Throwable {
        Element elm = null;
        switch (mode) {
            case 12: {
                if (1 == this.type && (this.name.equals("script") || FormTagFilterMap.instance.contains(this.name))) {
                    return this.build(doc, projectId);
                }
            }
            case 14: {
                if (1 == this.type && FormTagFilterMap.instance.contains(this.name)) {
                    return this.build(doc, projectId);
                }
                return null;
            }
            case 35: {
                if (1 == this.type && ObjectTagFilterMap.instance.contains(this.name)) {
                    return this.build(doc, projectId);
                }
                return null;
            }
            case 6: 
            case 30: {
                return this.build(doc, projectId);
            }
            case 2: {
                elm = doc.createElement(ELEMENT_NAME_ROOT);
                super.buildTextElement(elm, ELEMENT_NAME_NAME, this.name);
                super.buildTextElement(elm, ELEMENT_NAME_VALUE, this.value);
                super.buildTextElement(elm, ELEMENT_NAME_FLAG, this.flag);
                return elm;
            }
        }
        return null;
    }

    private Element build(Document doc, Integer projectId) throws Throwable {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        super.buildTextElement(elm, ELEMENT_NAME_NAME, this.name);
        super.buildTextElement(elm, ELEMENT_NAME_VALUE, this.value);
        HtmlNodeBean[] texts = HtmlNodesDAO.instance.findNodeByParentAndType(projectId, this.variationId, this.id, HtmlNodes.TYPE_TEXT_INTEGER);
        int i = texts.length - 1;
        while (i >= 0) {
            super.buildTextElement(elm, ELEMENT_NAME_TEXT, texts[i].value);
            --i;
        }
        HtmlNodeBean[] attrs = HtmlNodesDAO.instance.findNodeByParentAndType(projectId, this.variationId, this.id, HtmlNodes.TYPE_ATTRIBUTE_INTEGER);
        int i2 = attrs.length - 1;
        while (i2 >= 0) {
            HtmlNodeBean attr = attrs[i2];
            Element attrelm = doc.createElement(ELEMENT_NAME_ATTRIBUTE);
            super.buildTextElement(attrelm, ELEMENT_NAME_NAME, attr.name);
            super.buildTextElement(attrelm, ELEMENT_NAME_VALUE, attr.value);
            elm.appendChild(attrelm);
            --i2;
        }
        return elm;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        switch (mode) {
            case 12: 
            case 14: 
            case 35: {
                return HtmlNodesDAO.instance.findNodeByParentAndType(projectId, this.variationId, this.id, HtmlNodes.TYPE_ELEMENT_INTEGER);
            }
        }
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getContentsId() {
        return this.contentsId;
    }

    public void setContentsId(Integer contentsId) {
        this.contentsId = contentsId;
    }

    public Integer getVariationId() {
        return this.variationId;
    }

    public void setVariationId(Integer variationId) {
        this.variationId = variationId;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public Boolean getIncludedHalfKana() {
        return this.includedHalfKana;
    }

    public void setIncludedHalfKana(Boolean includedHalfKana) {
        this.includedHalfKana = includedHalfKana;
    }

    public Boolean getIncludedWrongChar() {
        return this.includedWrongChar;
    }

    public void setIncludedWrongChar(Boolean includedWrongChar) {
        this.includedWrongChar = includedWrongChar;
    }
}

