/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.filelistmaker;

import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.filelistmaker.MappingItem;

class MappingTableModel
implements TableModel {
    private static final String[] COLNAMES = new String[]{"URL", "local directory", "status"};
    private static final Class[] COLCLASS;
    private static final boolean[] COLEDITABLE;
    public static final int COLS;
    private final Vector listeners = new Vector();
    private final Vector items = new Vector();
    private boolean active = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        COLCLASS = classArray;
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        COLEDITABLE = blArray;
        COLS = COLNAMES.length;
    }

    public MappingTableModel() {
        this.appendRow();
    }

    public MappingItem[] toArray() {
        return this.items.toArray(new MappingItem[0]);
    }

    public void appendRow() {
        int pos = this.items.size();
        this.items.add(new MappingItem());
        this.fireChanged(new TableModelEvent(this, pos, pos, -1, 1));
    }

    public void setStatus(int row, String status) {
        MappingItem item = (MappingItem)this.items.get(row);
        item.status = status;
        this.fireChanged(new TableModelEvent(this, row, row, 2));
    }

    public int getColumnCount() {
        return COLS;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public boolean isCellEditable(int row, int col) {
        return this.active && COLEDITABLE[col];
    }

    public Class getColumnClass(int col) {
        return COLCLASS[col];
    }

    public Object getValueAt(int row, int col) {
        MappingItem item = (MappingItem)this.items.get(row);
        switch (col) {
            case 0: {
                return item.url;
            }
            case 1: {
                return item.dir;
            }
            case 2: {
                return item.status;
            }
        }
        return null;
    }

    public void setValueAt(Object obj, int row, int col) {
        MappingItem item = (MappingItem)this.items.get(row);
        switch (col) {
            case 0: {
                try {
                    item.url = obj == null ? null : URIOperator.instance.normalize((URL)obj);
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(null, obj + "\u306f\u6b63\u3057\u3044URL\u3067\u306f\u3042\u308a\u307e\u305b\u3093.\u6b63\u3057\u3044URL\u3092\u5165\u529b\u3057\u306a\u304a\u3057\u3066\u304f\u3060\u3055\u3044.", "error.", 0);
                }
                break;
            }
            case 1: {
                if (obj == null) {
                    item.dir = null;
                    break;
                }
                File dir = ((File)obj).getAbsoluteFile();
                if (dir.isDirectory()) {
                    item.dir = dir;
                    break;
                }
                JOptionPane.showMessageDialog(null, dir + "\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093.", "error.", 0);
            }
        }
        if (1 < this.items.size() && item.isEmpty()) {
            int pos = this.items.indexOf(item);
            this.items.remove(pos);
            this.fireChanged(new TableModelEvent(this, pos, pos, -1, -1));
        }
    }

    public String getColumnName(int col) {
        return COLNAMES[col];
    }

    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChanged(TableModelEvent event) {
        TableModelListener[] ls = this.listeners.toArray(new TableModelListener[0]);
        int i = ls.length - 1;
        while (i >= 0) {
            ls[i].tableChanged(event);
            --i;
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

