/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo;

import java.net.PasswordAuthentication;
import java.util.Hashtable;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeComplete;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeTarget;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnitMap;
import jp.co.nri.ridual.r2.analyzerobo.protocol.ProtocolProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.protocol.ProtocolProcessingUnitMap;
import jp.co.nri.ridual.r2.common.encodingmap.EncodingMap;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsVariationDAO;
import jp.co.nri.ridual.r2.db.dao.HistoryCache;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.BuildReportRoboController;

class AnalyzeRobo
extends AbstractRidualRobo {
    public static final Hashtable removingRobotsMap = new Hashtable();
    private static final int DEFAULT_REDEQUEUE_INTERVAL = 10000;
    private static final int REDEQUEUE_INTERVAL = AnalyzeRobo.buildInterval();
    private final ProtocolProcessingUnitMap ppuMap = new ProtocolProcessingUnitMap();
    private final ContentProcessingUnitMap cpuMap = new ContentProcessingUnitMap();

    public AnalyzeRobo() throws Throwable {
        super("analyze");
    }

    private static int buildInterval() {
        try {
            String interval = RidualResource.ANALYZEROBO_PROPERTIES.getString("robo.interval.dequeue");
            return Integer.parseInt(interval);
        }
        catch (Throwable t) {
            return 10000;
        }
    }

    public void cancel() {
        removingRobotsMap.put(this.id, this);
        super.cancel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void play() {
        AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
        while (true) {
            try {
                while (true) {
                    Object var10_15;
                    if (this.isCancel.booleanValue()) {
                        removingRobotsMap.remove(this.id);
                        return;
                    }
                    AnalyzeTarget target = queue.dequeue();
                    if (target == null) {
                        try {
                            Thread.sleep(REDEQUEUE_INTERVAL);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    Integer historyId = target.getHistoryId();
                    Integer contentsId = target.getContentsID();
                    Integer variationId = target.getVariationID();
                    HistoryCache historyCache = AnalyzeHistoryDAO.instance.getCache(historyId);
                    Integer projectId = historyCache.getProjectId();
                    try {
                        try {
                            int analyzeOptionFlags = historyCache.getAnalyzeOptionFlags();
                            ContentsAndVariationContainer con = ContentsAndVariationDAO.instance.load(projectId, variationId);
                            this.processing(projectId, con.contents, con.variation, target.getDepth(), historyCache.filesLimit, analyzeOptionFlags, historyCache.userInfo);
                        }
                        catch (Throwable t) {
                            ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze", "AnalyzeRobo.analyze", historyId, contentsId, variationId, null, t);
                        }
                    }
                    catch (Throwable throwable) {
                        var10_15 = null;
                        queue.markingAnalyzed(target);
                        throw throwable;
                    }
                    {
                        var10_15 = null;
                        queue.markingAnalyzed(target);
                        continue;
                    }
                    break;
                }
            }
            catch (AnalyzeComplete ac) {
                HistoryCache hc = (HistoryCache)ac.attachment;
                try {
                    BuildReportRoboController.instance.startBuildReportRoboAfterAnalyze(hc);
                }
                catch (Throwable t) {
                    ProjectLogDAO.instance.recordIssueHistory(hc.getProjectId(), "analyze", "AnalyzeRobo.buildReport", hc.history.getId(), null, t);
                }
                continue;
            }
            catch (Throwable t) {
                RidualServerLogDAO.getInstance().record("Robo.AnalyzeRobo", t);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processing(Integer projectId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, PasswordAuthentication userInfo) throws Throwable {
        block8: {
            block7: {
                try {
                    String scheme = content.getScheme();
                    ProtocolProcessingUnit ppunit = this.ppuMap.getProtocolProcessingUnit(scheme);
                    if (ppunit == null) {
                        variation.setType(33040);
                        Object var12_10 = null;
                        break block7;
                    }
                    if (!ppunit.cache(projectId, content, variation, depth, filesLimit, analyzeOptionFlags, userInfo)) break block8;
                    ContentProcessingUnit cpunit = this.cpuMap.getContentProcessingUnit(ppunit.getContentType(), content.getExtension());
                    String encoding = ppunit.getEncoding();
                    if (cpunit == null) {
                        variation.setType(33056);
                        variation.setRidualEncoding(this.ridualEncoding(encoding, projectId, content, variation.getId()));
                        break block8;
                    } else {
                        if (!cpunit.setProtocolEncoding(encoding)) {
                            ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze", "AnalyzeRobo.processing", content.getHistoryId(), content.getId(), variation.getId(), new Object[]{encoding}, null);
                        }
                        cpunit.processing(projectId, content, variation, depth, filesLimit, analyzeOptionFlags, ppunit.getCache());
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    ContentsVariationDAO.instance.update(projectId, variation);
                    throw throwable;
                }
            }
            ContentsVariationDAO.instance.update(projectId, variation);
            return;
        }
        Object var12_12 = null;
        ContentsVariationDAO.instance.update(projectId, variation);
    }

    private String ridualEncoding(String protocolEncoding, Integer projectId, ContentsBean content, Integer variationId) {
        if (protocolEncoding == null) {
            return ContentsVariationBean.RIDUAL_ENCODING_NONE;
        }
        if (EncodingMap.instance.isSupported(protocolEncoding)) {
            return protocolEncoding;
        }
        ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze", "AnalyzeRobo.processing", content.getHistoryId(), content.getId(), variationId, new Object[]{protocolEncoding}, null);
        return "";
    }
}

