/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.DecodeStringUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.StringCheckUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.StringCheckUnitMap;
import jp.co.nri.ridual.r2.common.encodingmap.EncodingMap;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;

public abstract class ContentProcessingUnitCommon
implements ContentProcessingUnit {
    protected String ridualEncoding;
    protected String charsetname;
    protected StringCheckUnit checker;

    public boolean setContentsEncoding(String encoding) throws Throwable {
        return encoding == null ? false : this.checkEncoidng(encoding);
    }

    public boolean setProtocolEncoding(String encoding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (encoding == null) {
            this.setEncodingAuto(ContentsVariationBean.RIDUAL_ENCODING_NONE);
            return true;
        }
        return this.checkEncoidng(encoding);
    }

    public DecodeStringUnit decodeWithCheck(String value) throws UnsupportedEncodingException {
        return new DecodeStringUnit(value, this.charsetname, this.checker);
    }

    public String decodeSimple(String value) throws UnsupportedEncodingException {
        return DecodeStringUnit.decodeSimple(this.charsetname, value);
    }

    private boolean checkEncoidng(String encname) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Charset cset = EncodingMap.instance.buildCharset(encname);
        if (cset == null) {
            this.setEncodingAuto("");
            return false;
        }
        this.setEncoding(cset, encname);
        return true;
    }

    private void setEncoding(Charset charset, String ridualEncoding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.ridualEncoding = ridualEncoding;
        this.charsetname = charset.name();
        this.checker = StringCheckUnitMap.getInstance().getStringCheckUnit(this.charsetname);
    }

    private void setEncodingAuto(String ridualEncoding) {
        this.ridualEncoding = ridualEncoding;
        this.charsetname = "JISAutoDetect";
        this.checker = null;
    }

    public String getRealEncoding() {
        return this.charsetname;
    }
}

