/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content;

import java.io.UnsupportedEncodingException;
import jp.co.nri.ridual.r2.analyzerobo.content.StringCheckUnit;

public class DecodeStringUnit {
    public final String str;
    public final Boolean includedHalfKana;
    public final Boolean includedWrongChar;

    public DecodeStringUnit() {
        this.str = null;
        this.includedHalfKana = null;
        this.includedWrongChar = null;
    }

    public DecodeStringUnit(String str, String charset, StringCheckUnit checker) throws UnsupportedEncodingException {
        Boolean wIncludedWrongChar;
        Boolean wIncludedHalfKana;
        if (str == null) {
            this.str = null;
            this.includedHalfKana = null;
            this.includedWrongChar = null;
            return;
        }
        byte[] bytes = str.getBytes("8859_1");
        if (checker == null) {
            wIncludedHalfKana = null;
            wIncludedWrongChar = null;
        } else {
            int flg = checker.check(bytes);
            wIncludedHalfKana = (flg & 1) != 0;
            wIncludedWrongChar = (flg & 2) != 0;
        }
        this.str = DecodeStringUnit.decodeSimple(charset, bytes);
        this.includedHalfKana = checker == null ? this.checkHalfKanaByUnicode(this.str.toCharArray()) : wIncludedHalfKana;
        this.includedWrongChar = wIncludedWrongChar;
    }

    public static String decodeSimple(String charset, String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("8859_1");
        return DecodeStringUnit.decodeSimple(charset, bytes);
    }

    private static String decodeSimple(String charset, byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, charset);
    }

    private Boolean checkHalfKanaByUnicode(char[] chars) {
        int charlen = chars.length;
        int i = 0;
        while (i < charlen) {
            char target = chars[i];
            if ('\uff61' <= target && target <= '\uff9f') {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }
}

