/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content;

import jp.co.nri.ridual.r2.analyzerobo.content.StringCheckUnit;

public class ISO2022JPStringCheckUnit
implements StringCheckUnit {
    private static final int MODE_MASK_NONE = 0;
    private static final int MODE_ASCII = 1;
    private static final int MODE_ROMAN = 2;
    private static final int MODE_KANA = 3;
    private static final int MODE_OLDJIS = 17;
    private static final int MODE_NEWJIS = 18;
    private static final int MODE_AID = 19;

    public int check(byte[] bytes) {
        int flg = 0;
        int mode = 0;
        boolean isSO = false;
        int len = bytes.length;
        int i = 0;
        while (i < len) {
            block20: {
                int c;
                block19: {
                    c = 0xFF & bytes[i];
                    if (27 != c) break block19;
                    if (len <= ++i) break;
                    byte b = bytes[i];
                    switch (b) {
                        case 36: {
                            if (len > ++i) {
                                mode = this.getMode2byte(bytes[i]);
                                break;
                            }
                            break block20;
                        }
                        case 40: {
                            if (len > ++i) {
                                mode = this.getMode1byte(bytes[i]);
                                break;
                            }
                            break block20;
                        }
                        default: {
                            mode = 0;
                            break;
                        }
                    }
                    break block20;
                }
                if (14 == c) {
                    isSO = true;
                } else if (14 == c) {
                    isSO = false;
                } else if (isSO) {
                    if (this.isJIS7HalfKana(c) || this.isJIS8HalfKana(c)) {
                        flg |= 1;
                    }
                } else {
                    switch (mode) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (!this.isJIS8HalfKana(c)) break;
                            flg |= 1;
                            break;
                        }
                        case 3: {
                            if (!this.isJIS7HalfKana(c) && !this.isJIS8HalfKana(c)) break;
                            flg |= 1;
                            break;
                        }
                        case 17: 
                        case 18: 
                        case 19: {
                            if (len <= ++i) break;
                            c <<= 8;
                            if ((10529 > (c |= 0xFF & bytes[i]) || c > 12158) && (29985 > c || c > 32382)) break;
                            flg |= 2;
                        }
                    }
                }
            }
            ++i;
        }
        return flg;
    }

    private int getMode1byte(byte b) {
        switch (b) {
            case 66: {
                return 1;
            }
            case 74: {
                return 2;
            }
            case 73: {
                return 3;
            }
        }
        return 0;
    }

    private int getMode2byte(byte b) {
        switch (b) {
            case 64: {
                return 17;
            }
            case 66: {
                return 18;
            }
            case 68: {
                return 19;
            }
        }
        return 0;
    }

    private boolean isJIS7HalfKana(int c) {
        return 33 <= c && c <= 95;
    }

    private boolean isJIS8HalfKana(int c) {
        return 161 <= c && c <= 223;
    }
}

