/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.html;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnitCommon;
import jp.co.nri.ridual.r2.analyzerobo.content.DecodeStringUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.DocTypeRegex;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaConfig;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaData;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAttributeUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAttributeUnitMap;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlElementUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlElementUnitMap;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlNodeAnaData;
import jp.co.nri.ridual.r2.analyzerobo.content.html.SupplementTextMap;
import jp.co.nri.ridual.r2.analyzerobo.content.html.SupplementTextUnit;
import jp.co.nri.ridual.r2.common.formparamap.FormParaMap;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.bean.project.HtmlNodeBean;
import jp.co.nri.ridual.r2.db.bean.project.ImageBean;
import jp.co.nri.ridual.r2.db.dao.ContentsRelationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSet;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.HtmlNodesDAO;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.WebCaptureQueueDAO;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class HtmlContentProcessingUnit
extends ContentProcessingUnitCommon {
    private static final String LF = "\n";
    private final Tidy tidy = new Tidy();
    private final HtmlElementUnitMap elementMap;
    private final HtmlAttributeUnitMap attributeMap = new HtmlAttributeUnitMap();
    private final SupplementTextMap supplementTextMap = new SupplementTextMap();
    private HtmlAnaConfig config;
    private HtmlAnaData htmlAnaData;
    private AnalyzeQueue queue;

    public HtmlContentProcessingUnit() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Properties p = new Properties();
        p.put("tidy-mark", "false");
        p.put("quote-marks", "true");
        this.tidy.setConfigurationFromProps(p);
        this.tidy.setQuiet(true);
        this.tidy.setShowWarnings(true);
        this.tidy.setIndentContent(false);
        this.tidy.setIndentAttributes(false);
        this.tidy.setSmartIndent(false);
        this.tidy.setWraplen(0);
        this.tidy.setXHTML(false);
        this.tidy.setXmlOut(true);
        this.tidy.setMakeClean(false);
        this.tidy.setCharEncoding(0);
        this.elementMap = new HtmlElementUnitMap();
    }

    public String[] getKeys() {
        return new String[]{"text/html", "application/xhtml+xml", "text/x-server-parsed-html"};
    }

    public void processing(Integer prjId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, byte[] b) {
        try {
            String fpi;
            DocumentType doctype;
            URL captureURL;
            boolean isCapture;
            variation.setType(273);
            this.config = new HtmlAnaConfig(prjId, content, variation, depth, filesLimit, analyzeOptionFlags);
            this.htmlAnaData = new HtmlAnaData();
            this.queue = AnalyzeQueueFactory.getAnalyzeQueue();
            boolean bl = isCapture = (analyzeOptionFlags & 0x20) != 0;
            if (isCapture && (captureURL = content.buildURLNoAnchor(variation)) != null) {
                ImageBean imageBean = new ImageBean();
                imageBean.setHistoryId(this.config.historyId);
                ImageDAO.instance.save(prjId, imageBean);
                Integer imageId = imageBean.getId();
                variation.setThumbnailId(imageId);
                WebCaptureQueueDAO.instance.enqueue(prjId, this.config.historyId, imageId, captureURL.toString());
            }
            StringWriter errors = new StringWriter();
            this.tidy.setErrout(new PrintWriter((Writer)errors, true));
            Document doc = this.tidy.parseDOM((InputStream)new ByteArrayInputStream(b), null);
            String mes = Patterns.CRLF_PATTERN.matcher(errors.toString()).replaceAll(LF).trim();
            if (mes.length() > 0) {
                ContentsSupplementDAO.instance.save(prjId, content.getId(), variation.getId(), null, "HTML.checkMessages", mes);
            }
            if ((doctype = doc.getDoctype()) != null && (fpi = this.getFIP(doctype.getName())) != null) {
                ContentsSupplementDAO.instance.save(this.config.projectId, this.config.contentsId, this.config.variationId, "doctype", "HTML.doctype", fpi);
            }
            this.traceNode(doc, null);
            variation.setRidualEncoding(this.ridualEncoding);
            ContentsSupplementDAO.instance.save(this.config.projectId, this.config.contentsId, this.config.variationId, "html", "HTML.tableNestDepth", this.htmlAnaData.getMaxTableDepth());
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(prjId, "analyze.html", "AnalyzeRobo.HTML", content.getHistoryId(), content.getId(), variation.getId(), null, t);
        }
    }

    private void traceNode(Node node, Integer parentId) {
        HtmlNodeAnaData nodeAnaData = this.buildHtmlNodeAnaData(node);
        switch (nodeAnaData.type) {
            case 1: {
                Element elm = (Element)node;
                HtmlElementUnit elementUnit = this.elementMap.getHtmlElementUnit(nodeAnaData.name);
                if (elementUnit != null) {
                    elementUnit.play(elm, this, this.config, this.htmlAnaData, nodeAnaData);
                }
                SupplementTextUnit supplement = this.supplementTextMap.get(nodeAnaData.name);
                try {
                    this.saveSupplement(elm, supplement);
                    break;
                }
                catch (UnsupportedEncodingException usee) {
                    ProjectLogDAO.instance.recordIssueVariation(this.config.projectId, "analyze.html", "AnalyzeRobo.HTML.text.unsupportedEncoding", this.config.historyId, this.config.contentsId, this.config.variationId, new Object[]{nodeAnaData.name}, usee);
                    break;
                }
                catch (Throwable t) {
                    ProjectLogDAO.instance.recordIssueVariation(this.config.projectId, "analyze.html", "AnalyzeRobo.HTML.text", this.config.historyId, this.config.contentsId, this.config.variationId, new Object[]{nodeAnaData.name}, t);
                }
            }
        }
        try {
            NodeList list;
            Integer id = this.saveHTMLNode(parentId, nodeAnaData);
            this.htmlAnaData.push(nodeAnaData);
            NamedNodeMap map = node.getAttributes();
            if (map != null) {
                int len = map.getLength();
                int i = 0;
                while (i < len) {
                    this.traceNodeAttribute(id, nodeAnaData.name, (Attr)map.item(i));
                    ++i;
                }
            }
            if ((list = node.getChildNodes()) != null) {
                int len = list.getLength();
                int i = 0;
                while (i < len) {
                    this.traceNode(list.item(i), id);
                    ++i;
                }
            }
            this.htmlAnaData.pop(nodeAnaData);
            this.saveRelationAndEnqueue(id, nodeAnaData);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.config.projectId, "analyze.html", "AnalyzeRobo.HTML.trace", this.config.historyId, this.config.contentsId, this.config.variationId, new Object[]{nodeAnaData.name, nodeAnaData.value.str}, t);
        }
    }

    private void traceNodeAttribute(Integer parentId, String elmname, Attr attr) throws Throwable {
        HtmlNodeAnaData nodeAnaData = this.buildHtmlNodeAnaData(attr);
        HtmlAttributeUnit attrUnit = this.attributeMap.getHtmlAttributeUnit(nodeAnaData.name);
        if (attrUnit != null) {
            attrUnit.play(elmname, attr, this, this.config, this.htmlAnaData, nodeAnaData);
        }
        Integer id = this.saveHTMLNode(parentId, nodeAnaData);
        this.saveRelationAndEnqueue(id, nodeAnaData);
    }

    private Integer saveHTMLNode(Integer parentId, HtmlNodeAnaData nodeAnaData) throws Throwable {
        if (!this.config.isSaveNode) {
            return null;
        }
        HtmlNodeBean htmlNode = new HtmlNodeBean();
        htmlNode.setContentsId(this.config.contentsId);
        htmlNode.setVariationId(this.config.variationId);
        htmlNode.setParentId(parentId);
        htmlNode.setName(nodeAnaData.name);
        htmlNode.setValue(nodeAnaData.value.str);
        htmlNode.setType(nodeAnaData.type);
        htmlNode.setIncludedHalfKana(nodeAnaData.value.includedHalfKana);
        htmlNode.setIncludedWrongChar(nodeAnaData.value.includedWrongChar);
        htmlNode.setValue(nodeAnaData.value.str);
        htmlNode.setFlag(nodeAnaData.nodeFlag);
        HtmlNodesDAO.instance.save(this.config.projectId, htmlNode);
        return htmlNode.getId();
    }

    private HtmlNodeAnaData buildHtmlNodeAnaData(Node node) {
        return new HtmlNodeAnaData(node.getNodeName(), this.buildDecodeStringUnit(node.getNodeValue()), node.getNodeType());
    }

    public boolean setContentsEncoding(String encoding) throws Throwable {
        boolean val = super.setContentsEncoding(encoding);
        if (val) {
            ContentsSupplementDAO.instance.save(this.config.projectId, this.config.contentsId, this.config.variationId, "html", "HTML.encoding", encoding);
        }
        return val;
    }

    private String getFIP(String val) {
        if (val == null) {
            return null;
        }
        String doctype = Patterns.LF_PATTERN.matcher(Patterns.CRLF_PATTERN.matcher(Patterns.TAB_PATTERN.matcher(val).replaceAll(" ")).replaceAll(" ")).replaceAll(" ").trim();
        int len = DocTypeRegex.getInstance().DCOTYPENAME.length;
        int i = 0;
        while (i < len) {
            if (DocTypeRegex.getInstance().DOCTYPE[i].matcher(doctype).matches()) {
                return DocTypeRegex.getInstance().DCOTYPENAME[i];
            }
            ++i;
        }
        return "";
    }

    private DecodeStringUnit buildDecodeStringUnit(String value) {
        try {
            return super.decodeWithCheck(value);
        }
        catch (Exception e) {
            ProjectLogDAO.instance.recordIssueVariation(this.config.projectId, "analyze.html", "AnalyzeRobo.HTML.unsupportedEncoding", this.config.historyId, this.config.contentsId, this.config.variationId, new Object[]{this.charsetname, value}, e);
            return new DecodeStringUnit();
        }
    }

    private void saveSupplement(Element elm, SupplementTextUnit supplement) throws UnsupportedEncodingException, Throwable {
        if (supplement == null) {
            return;
        }
        String supplementValue = supplement.isValue ? this.getText(elm) : null;
        ContentsSupplementDAO.instance.save(this.config.projectId, this.config.contentsId, this.config.variationId, supplement.category, supplement.name, supplementValue);
    }

    private String getText(Element element) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        NodeList nlist = element.getChildNodes();
        int len = nlist.getLength();
        int i = 0;
        while (i < len) {
            Node n = nlist.item(i);
            if (3 == n.getNodeType()) {
                sb.append(n.getNodeValue());
            }
            ++i;
        }
        return super.decodeSimple(sb.toString());
    }

    private void saveRelationAndEnqueue(Integer nodeId, HtmlNodeAnaData nodeAnaData) {
        try {
            if (nodeAnaData.relationType == null) {
                return;
            }
            if (nodeAnaData.relationURL == null) {
                ContentsRelationDAO.instance.saveSelfRelation(this.config.projectId, this.config.contentsId, this.config.variationId, nodeId, nodeAnaData.relationType);
            } else {
                ContentsSet[] childContentsSets = ContentsRelationDAO.instance.saveWithloadOrSaveWithContentsAndVatiation(this.config.projectId, this.config.historyId, this.config.contentsId, this.config.variationId, this.config.parentURL, nodeAnaData.relationURL, nodeAnaData.isPost, null, nodeId, nodeAnaData.relationType, new FormParaMap[]{nodeAnaData.formParaMap});
                int len = childContentsSets.length;
                int i = 0;
                while (i < len) {
                    ContentsSet childContentsSet = childContentsSets[i];
                    if (!childContentsSet.variationIsLoad) {
                        this.queue.enqueue(this.config.historyId, childContentsSet.contents.getId(), childContentsSet.variation.getId(), this.config.depthNext, this.config.filesLimit);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.config.projectId, "analyze.html", "AnalyzeRobo.HTML.attribute.enqueue", this.config.historyId, this.config.contentsId, this.config.variationId, new Object[]{nodeAnaData.relationAttribute, nodeAnaData.relationURL}, t);
        }
    }
}

