/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnitCommon;
import jp.co.nri.ridual.r2.common.image.ImageScaler;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.bean.project.ImageBean;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.resource.RidualResource;

public class ImageContentProcessingUnit
extends ContentProcessingUnitCommon {
    private static final int THUMB_W = Integer.parseInt(RidualResource.ANALYZEROBO_PROPERTIES.getString("image.thumbnail.width"));
    private static final int THUMB_H = Integer.parseInt(RidualResource.ANALYZEROBO_PROPERTIES.getString("image.thumbnail.height"));
    private final ImageScaler scaler = new ImageScaler(THUMB_W, THUMB_H);

    public String[] getKeys() {
        return new String[]{"image/jpeg", "image/gif", "image/png"};
    }

    public void processing(Integer projectId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, byte[] b) {
        try {
            variation.setType(529);
            BufferedImage bi = this.openImage(variation.getRidualContentType(), b);
            if (bi == null) {
                return;
            }
            int width = bi.getWidth();
            int height = bi.getHeight();
            Integer contentId = content.getId();
            Integer variationId = variation.getId();
            ContentsSupplementDAO.instance.save(projectId, contentId, variationId, null, "IMAGE.height", new Integer(height));
            ContentsSupplementDAO.instance.save(projectId, contentId, variationId, null, "IMAGE.width", new Integer(width));
            if ((analyzeOptionFlags & 0x40) != 0) {
                ImageBean imageBean = new ImageBean();
                imageBean.setHistoryId(content.getHistoryId());
                imageBean.setJpegImage(this.scaler.scale(bi));
                ImageDAO.instance.save(projectId, imageBean);
                variation.setThumbnailId(imageBean.getId());
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.image", "AnalyzeRobo.image", content.getHistoryId(), content.getId(), variation.getId(), null, t);
        }
    }

    private BufferedImage openImage(String contenttype, byte[] b) throws IOException {
        BufferedImage bufferedImage;
        Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType(contenttype);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(b));
        try {
            reader.setInput(iis, true);
            bufferedImage = reader.read(0);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iis.close();
            throw throwable;
        }
        iis.close();
        return bufferedImage;
    }
}

