/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.swf;

import java.net.URL;
import jp.co.iti.swf.SWFDocument;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.analyzerobo.content.ContentProcessingUnitCommon;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.bean.project.ImageBean;
import jp.co.nri.ridual.r2.db.dao.ContentsRelationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSet;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.WebCaptureQueueDAO;

public class SwfContentProcessingUnit
extends ContentProcessingUnitCommon {
    private final AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();

    public String[] getKeys() {
        return new String[]{"application/x-shockwave-flash"};
    }

    public void processing(Integer projectId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, byte[] b) {
        if (depth <= 0) {
            return;
        }
        Integer historyId = content.getHistoryId();
        Integer contentId = content.getId();
        Integer variationId = variation.getId();
        try {
            URL captureURL;
            if ((analyzeOptionFlags & 0x80) != 0 && (captureURL = content.buildURLNoAnchor(variation)) != null) {
                ImageBean imageBean = new ImageBean();
                imageBean.setHistoryId(historyId);
                ImageDAO.instance.save(projectId, imageBean);
                Integer imageId = imageBean.getId();
                variation.setThumbnailId(imageId);
                WebCaptureQueueDAO.instance.enqueue(projectId, historyId, imageId, captureURL.toString());
            }
            variation.setType(785);
            if ((analyzeOptionFlags & 4) == 0) {
                return;
            }
            URL parentURL = content.buildURL(variation);
            SWFDocument swfdoc = new SWFDocument(b);
            String[] urls = swfdoc.getURLs(parentURL);
            int depthNext = depth - 1;
            int i = urls.length - 1;
            while (i >= 0) {
                ContentsSet childContentsSet = ContentsRelationDAO.instance.saveWithloadOrSaveWithContentsAndVatiation(projectId, historyId, contentId, variationId, parentURL, urls[i], null, "swf", null);
                if (!childContentsSet.variationIsLoad) {
                    this.queue.enqueue(historyId, childContentsSet.contents.getId(), childContentsSet.variation.getId(), depthNext, filesLimit);
                }
                --i;
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.swf", "AnalyzeRobo.image", historyId, contentId, variationId, null, t);
        }
    }
}

