/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.protocol.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.analyzerobo.RidualAuthenticator;
import jp.co.nri.ridual.r2.analyzerobo.protocol.ProtocolProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.protocol.http.AbstractHttpUnit;
import jp.co.nri.ridual.r2.common.contenttype.ContentType;
import jp.co.nri.ridual.r2.common.httpdecodemapshell.HttpDecodeMapShell;
import jp.co.nri.ridual.r2.common.refresh.Refresh;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.dao.ContentsRelationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSet;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;

public class HttpProtocolProcessingUnit
extends AbstractHttpUnit
implements ProtocolProcessingUnit {
    private static final String HTTP_HEADER_REFRESH = "Refresh";
    private static final String HTTP_HEADER_LOCATION = "Location";
    private final byte[] buf = new byte[8192];
    private String contentType = null;
    private String encoding = null;
    private byte[] cache = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cache(Integer projectId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, PasswordAuthentication userInfo) {
        int len;
        BufferedInputStream bin;
        ByteArrayOutputStream ostream;
        this.contentType = null;
        this.encoding = null;
        this.cache = null;
        if (!content.getIsInner().booleanValue()) {
            userInfo = null;
        }
        URL authUrl = null;
        HttpURLConnection connection = null;
        try {
            try {
                boolean isTraceLink;
                authUrl = content.buildURL4Auth();
                super.lockConnect(authUrl, userInfo);
                connection = super.connect(content, variation);
                int code = connection.getResponseCode();
                String ctype = connection.getContentType();
                String connectionEncoding = connection.getContentEncoding();
                ContentType ct = new ContentType(ctype);
                this.contentType = ct.contenttype;
                this.encoding = connectionEncoding == null ? ct.encoding : connectionEncoding;
                Integer contentId = content.getId();
                Integer variationId = variation.getId();
                variation.setHttpContentType(ctype);
                variation.setRidualContentType(this.contentType);
                variation.setHttpStatus(code);
                int sz = connection.getContentLength();
                variation.setSize(sz < 0 ? null : new Integer(sz));
                variation.setLastModified(new Date(connection.getLastModified()));
                variation.setSetCookie(connection.getHeaderField("Set-Cookie"));
                if (this.encoding != null) {
                    ContentsSupplementDAO.instance.save(projectId, contentId, variationId, null, "HTTP.contentEncoding", this.encoding);
                }
                HttpDecodeMapShell headers = new HttpDecodeMapShell(connection.getHeaderFields());
                this.mapToSupplement(projectId, contentId, variationId, "http.headerFields", headers);
                ContentsSupplementDAO.instance.save(projectId, contentId, variationId, null, "HTTP.responseMessage", connection.getResponseMessage());
                boolean flg = (analyzeOptionFlags & 1) != 0;
                boolean bl = isTraceLink = flg && depth > 0 && content.getIsInner() != false;
                if (isTraceLink) {
                    String[] locations = headers.getList(HTTP_HEADER_LOCATION);
                    String[] refreshs = headers.getList(HTTP_HEADER_REFRESH);
                    if (locations != null && refreshs != null) {
                        ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.http", "AnalyzeRobo.HTTP.headerMixed", content.getHistoryId(), contentId, variationId, null, null);
                    }
                    this.enqueue(projectId, content, variation, depth, filesLimit, locations, HTTP_HEADER_LOCATION, "AnalyzeRobo.HTTP.header.duplicateLocation");
                    this.enqueue(projectId, content, variation, depth, filesLimit, refreshs, HTTP_HEADER_REFRESH, "AnalyzeRobo.HTTP.header.duplicateRefresh");
                }
                if (200 != code) {
                    Object var25_25 = null;
                    if (connection != null) {
                        connection.disconnect();
                    }
                    RidualAuthenticator.instance.relAnaSite(authUrl);
                    return false;
                }
                ostream = new ByteArrayOutputStream();
                bin = new BufferedInputStream(connection.getInputStream());
                try {}
                catch (Throwable throwable) {
                    Object var23_33 = null;
                    bin.close();
                    throw throwable;
                }
            }
            catch (ConnectException e) {
                variation.setHttpStatus(-3);
                variation.setType(33312);
                Object var25_27 = null;
                if (connection != null) {
                    connection.disconnect();
                }
                RidualAuthenticator.instance.relAnaSite(authUrl);
                return false;
            }
            catch (UnknownHostException e) {
                variation.setHttpStatus(-2);
                variation.setType(33296);
                Object var25_28 = null;
                if (connection != null) {
                    connection.disconnect();
                }
                RidualAuthenticator.instance.relAnaSite(authUrl);
                return false;
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.http", "AnalyzeRobo.cache", content.getHistoryId(), content.getId(), variation.getId(), null, t);
                Object var25_29 = null;
                if (connection != null) {
                    connection.disconnect();
                }
                RidualAuthenticator.instance.relAnaSite(authUrl);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var25_30 = null;
            if (connection != null) {
                connection.disconnect();
            }
            RidualAuthenticator.instance.relAnaSite(authUrl);
            throw throwable;
        }
        while ((len = bin.read(this.buf)) >= 0) {
            ostream.write(this.buf, 0, len);
        }
        Object var23_34 = null;
        bin.close();
        ostream.flush();
        this.cache = ostream.toByteArray();
        Object var25_26 = null;
        if (connection != null) {
            connection.disconnect();
        }
        RidualAuthenticator.instance.relAnaSite(authUrl);
        return true;
    }

    public byte[] getCache() {
        return this.cache;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void mapToSupplement(Integer projectId, Integer contentId, Integer variationId, String category, HttpDecodeMapShell map) throws Throwable {
        Object[] keys = map.getKeys();
        int ilen = keys.length;
        int i = 0;
        while (i < ilen) {
            String key = (String)keys[i];
            String[] vals = map.getList(key);
            if (key == null) {
                key = "";
            }
            int jlen = vals.length;
            int j = 0;
            while (j < jlen) {
                ContentsSupplementDAO.instance.save(projectId, contentId, variationId, category, key, vals[j]);
                ++j;
            }
            ++i;
        }
    }

    private void enqueue(Integer projectId, ContentsBean content, ContentsVariationBean variation, int depth, int filesLimit, String[] list, String key, String logCodeDuplicate) {
        if (list == null) {
            return;
        }
        Integer historyId = content.getHistoryId();
        Integer contentId = content.getId();
        Integer variationId = variation.getId();
        int len = list.length;
        if (1 < len) {
            ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.http", logCodeDuplicate, historyId, contentId, variationId, null, null);
        }
        int depthNext = depth - 1;
        AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
        int i = 0;
        while (i < len) {
            Refresh refresh = new Refresh(list[i]);
            try {
                if (refresh.url == null) {
                    ContentsRelationDAO.instance.saveSelfRelation(projectId, contentId, variationId, null, "http.header");
                } else {
                    URL parentURL = content.buildURL(variation);
                    ContentsSet childContentsSet = ContentsRelationDAO.instance.saveWithloadOrSaveWithContentsAndVatiation(projectId, historyId, contentId, variationId, parentURL, refresh.url, null, "http.header", null);
                    if (!childContentsSet.variationIsLoad) {
                        queue.enqueue(historyId, childContentsSet.contents.getId(), childContentsSet.variation.getId(), depthNext, filesLimit);
                    }
                }
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueVariation(projectId, "analyze.http", "AnalyzeRobo.HTTP.enqueue", historyId, contentId, variationId, new Object[]{key, refresh.url}, t);
            }
            ++i;
        }
    }
}

