/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.common;

import java.net.URL;
import java.util.Date;
import java.util.List;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.common.AbstractCommonNodable;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.common.DifferenceMapRobo;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.LocalDifferenceContainer;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.DirectoryMapDAO;
import jp.co.nri.ridual.r2.db.dao.LocalFileDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocalHistoryBean
extends AbstractCommonNodable {
    public static final String HQL_QUERY_NAME_FIND_BY_SITE_ID = "localHistory.findBySiteId";
    public static final String HQL_QUERY_NAME_FIND_DETACHED_BY_SITE_ID = "localHistory.findDetachedBySiteId";
    public static final String HQL_QUERY_NAME_FIND_BY_HISTORY_ID = "localHistory.findByHistoryId";
    public static final String HQL_QUERY_NAME_LOAD_ACTIVE = "localHistory.loadActive";
    public static final String HQL_QUERY_NAME_UPDATE_READY_AND_HISTORY_ID = "localHistory.updateReadyAndHistoryId";
    public static final String HQL_QUERY_NAME_UPDATE_HISTORY_ID = "localHistory.updateHistoryId";
    public static final String HQL_QUERY_NAME_RESET_HISTORY_ID = "localHistory.resetHistoryId";
    public static final String HQL_QUERY_NAME_UPDATE_DELETE = "localHistory.updateDelete";
    private static final String ELEMENT_NAME_ROOT = "LOCAL_HISTORY";
    private static final String ELEMENT_NAME_ID = "ID";
    private static final String ELEMENT_NAME_TIMESTAMP = "TIMESTAMP";
    private static final String ELEMENT_NAME_HISTORY_ID = "HISTORY_ID";
    private Integer id;
    private Integer siteId;
    private Integer historyId = null;
    private Date timestamp;
    private boolean ready = false;
    private boolean deleted = false;

    public Node buildNode(int mode, Document doc) throws Throwable {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        super.buildElement(elm, ELEMENT_NAME_ID, this.id);
        super.buildDateElement(elm, ELEMENT_NAME_TIMESTAMP, this.timestamp);
        switch (mode) {
            case 18: {
                super.buildElement(elm, ELEMENT_NAME_HISTORY_ID, this.historyId);
            }
        }
        return elm;
    }

    public AbstractNodable[] loadChild(int mode) throws Throwable {
        switch (mode) {
            case 18: 
            case 20: 
            case 21: {
                AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
                return DirectoryMapDAO.instance.findByLocalHistoryId(siteBean.getProjectId(), this.id).toArray(new AbstractNodable[0]);
            }
            case 19: {
                AnalyzeSiteConfigBean site = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
                Integer projectId = site.getProjectId();
                List list = DirectoryMapDAO.instance.findByLocalHistoryId(projectId, this.id);
                list.addAll(LocalFileDAO.instance.countAndsumByExtension(projectId, this.id));
                return list.toArray(new AbstractNodable[0]);
            }
            case 22: {
                return this.historyId == null ? null : this.difference();
            }
            case 23: {
                AnalyzeSiteConfigBean sBean = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
                return new AbstractNodable[]{sBean};
            }
        }
        return null;
    }

    private AbstractNodable[] difference() throws Throwable {
        AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
        Integer projectId = siteBean.getProjectId();
        DifferenceMapRobo diffmapRobo = new DifferenceMapRobo(LocalFileDAO.instance.findForDifference(projectId, this.id));
        diffmapRobo.start();
        List contents = ContentsAndVariationDAO.instance.findByIsInner(projectId, this.historyId, true);
        ContentsAndVariationContainer[] cvs = contents.toArray(new ContentsAndVariationContainer[0]);
        diffmapRobo.join();
        int i = cvs.length - 1;
        while (i >= 0) {
            ContentsAndVariationContainer cv = cvs[i];
            URL url = cv.contents.buildURL();
            LocalDifferenceContainer ld = diffmapRobo.get(url);
            if (ld == null) {
                diffmapRobo.put(url, cv);
            } else {
                ld.add(cv);
            }
            --i;
        }
        return diffmapRobo.toArray();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public Integer getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(Integer historyId) {
        this.historyId = historyId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean getReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

