/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import jp.co.nri.ridual.r2.common.messageformat.MessageFormatter;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.db.bean.project.log.ProjectLogBean;
import jp.co.nri.ridual.r2.db.bean.project.log.ProjectLogSupplementBean;
import jp.co.nri.ridual.r2.db.dao.DefaultProjectDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;

public class ProjectLogDAO
extends DefaultProjectDAO {
    public static final ProjectLogDAO instance = new ProjectLogDAO();
    private static final String LF = "\n";

    private ProjectLogDAO() {
        super(0);
    }

    public void recordIssueVariation(Integer projectId, String method, String code, Integer historyId, Integer contentsId, Integer variationId, Object[] param, Throwable t) {
        this.record(projectId, "issue.variation", method, code, historyId, contentsId, variationId, param, t);
    }

    public void recordIssueHistory(Integer projectId, String method, String code, Integer historyId, Object[] param, Throwable t) {
        this.record(projectId, "issue.history", method, code, historyId, null, null, param, t);
    }

    public void recordIssueProject(Integer projectId, String method, String code, Object[] param, Throwable t) {
        this.record(projectId, "issue.project", method, code, null, null, null, param, t);
    }

    private void record(Integer projectId, String type, String method, String code, Integer historyId, Integer contentsId, Integer variationId, Object[] param, Throwable t) {
        ProjectLogBean bean = new ProjectLogBean();
        bean.setType(type);
        bean.setMethod(method);
        bean.setCode(code);
        bean.setHistoryId(historyId);
        bean.setContentsId(contentsId);
        bean.setVariationId(variationId);
        bean.setMessage(MessageFormatter.instance.formatProjectLogMessage(code, param));
        try {
            super.save(projectId, bean);
            if (t != null) {
                Integer logId = bean.getId();
                ArrayList<ProjectLogSupplementBean> supplements = new ArrayList<ProjectLogSupplementBean>();
                supplements.add(this.buildSupplement(logId, "LocalizedMessage", t.getLocalizedMessage()));
                supplements.add(this.buildSupplement(logId, "Message", t.getMessage()));
                supplements.add(this.buildSupplement(logId, "Class", t.getClass().getName()));
                StringWriter strwriter = new StringWriter();
                t.printStackTrace(new PrintWriter((Writer)strwriter, true));
                supplements.add(this.buildSupplement(logId, "StackTrace", strwriter.toString()));
                super.save(projectId, supplements.toArray());
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
        }
    }

    public List findIssueProject(Integer projectId) throws Throwable {
        try {
            return super.findByName(projectId, "projectlog.findIssueProject");
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
            throw e;
        }
    }

    public List findIssueHistory(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.findByName(projectId, "projectlog.findIssueHistory", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
            throw e;
        }
    }

    public List findIssueVariation(Integer projectId, Integer variationId) throws Throwable {
        try {
            return super.findByName(projectId, "projectlog.findIssueVariation", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
            throw e;
        }
    }

    public List findByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            return super.findByName(projectId, "projectlog.findByVariationId", new Object[]{variationId});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
            throw e;
        }
    }

    public List findByHistoryId(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.findByName(projectId, "projectlog.findByHistoryId", new Object[]{historyId});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
            throw e;
        }
    }

    public int countByHistoryId(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "projectlog.countByHistoryId", new Object[]{historyId});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog", e);
            throw e;
        }
    }

    public List findSupplementByLogId(Integer projectId, Integer logId) throws Throwable {
        try {
            return super.findByName(projectId, "projectlog.supplement.findByLogId", new Object[]{logId});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.ProjectLog.Supplement", e);
            throw e;
        }
    }

    private ProjectLogSupplementBean buildSupplement(Integer logId, String name, String value) {
        ProjectLogSupplementBean supplement = new ProjectLogSupplementBean();
        supplement.setLogId(logId);
        supplement.setName(name);
        supplement.setValue(value == null ? null : Patterns.CRLF_PATTERN.matcher(value).replaceAll(LF));
        return supplement;
    }
}

