/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.co.nri.ridual.r2.db.bean.common.RatingProfileItemBean;
import jp.co.nri.ridual.r2.db.dao.RatingProfileDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.rating.CategoryItem;
import jp.co.nri.ridual.r2.rating.GlobalRatingCategory;
import jp.co.nri.ridual.r2.rating.RatingCategory;
import jp.co.nri.ridual.r2.rating.RatingPluginInfo;
import jp.co.nri.ridual.r2.rating.RatingPluginJar;
import jp.co.nri.ridual.r2.rating.RatingPluginJarManifestNoKeyException;
import jp.co.nri.ridual.r2.rating.RatingPluginJarManifestPluginConfigDuplicationException;
import jp.co.nri.ridual.r2.rating.RatingPluginJarManifestPluginConfigException;
import jp.co.nri.ridual.r2.rating.RatingPluginJarNoManifestException;
import jp.co.nri.ridual.r2.rating.RatingPluginList;
import jp.co.nri.ridual.r2.rating.RatingPluginMap;

public class RatingInfo {
    private static final String RATING_ENTRY = "ratingentry.txt";
    public static final RatingInfo instance = new RatingInfo();
    public RatingCategory[] category = null;
    public final GlobalRatingCategory globalcategory = new GlobalRatingCategory();
    private RatingPluginMap pluginInfoMap = null;

    private RatingInfo() {
    }

    public RatingPluginInfo getPluginInfo(String classname) {
        return this.pluginInfoMap.get(classname);
    }

    public int getAllRatingCount() {
        return this.pluginInfoMap.size();
    }

    public void load(String path) {
        if (this.pluginInfoMap != null) {
            return;
        }
        try {
            this.pluginInfoMap = new RatingPluginMap();
            ArrayList<RatingCategory> list = new ArrayList<RatingCategory>();
            RatingPluginList jarlist = new RatingPluginList(new File(path, RATING_ENTRY));
            int len = jarlist.jarnames.length;
            int i = 0;
            while (i < len) {
                String jarname = jarlist.jarnames[i];
                try {
                    RatingPluginJar jar = new RatingPluginJar(new File(path, jarname));
                    this.pluginInfoMap.entry(jar);
                    list.add(new RatingCategory(jar));
                }
                catch (RatingPluginJarNoManifestException e) {
                    RidualServerLogDAO.getInstance().record("Rating.RatingInfo", "Rating.Error.PluginJar.NoManifest", new Object[]{e.file}, null);
                }
                catch (RatingPluginJarManifestNoKeyException e) {
                    RidualServerLogDAO.getInstance().record("Rating.RatingInfo", "Rating.Error.PluginJar.Manifest.NoKey", new Object[]{e.file, e.key}, null);
                }
                catch (RatingPluginJarManifestPluginConfigException e) {
                    RidualServerLogDAO.getInstance().record("Rating.RatingInfo", "Rating.Error.PluginJar.Manifest.PluginConfig", new Object[]{e.config}, null);
                }
                catch (RatingPluginJarManifestPluginConfigDuplicationException e) {
                    RidualServerLogDAO.getInstance().record("Rating.RatingInfo", "Rating.Error.PluginJar.Manifest.PluginConfig.duplication", new Object[]{e.clazz}, null);
                }
                catch (Throwable t) {
                    RidualServerLogDAO.getInstance().record("Rating.RatingInfo", "Rating.Error.PluginJar", new Object[]{jarname}, t);
                }
                ++i;
            }
            this.category = list.toArray(new RatingCategory[0]);
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("Rating.RatingInfo", t);
        }
    }

    public CategoryItem[] getloadEdit(Integer profileId) throws Throwable {
        if (this.category == null) {
            return null;
        }
        List rplist = RatingProfileDAO.instance.findItemsByProfileId(profileId);
        RatingProfileItemBean[] rpbean = rplist.toArray(new RatingProfileItemBean[0]);
        HashMap<String, RatingProfileItemBean> profilemap = new HashMap<String, RatingProfileItemBean>();
        int beansize = rpbean.length;
        int i = 0;
        while (i < beansize) {
            profilemap.put(rpbean[i].getClazz(), rpbean[i]);
            ++i;
        }
        int categorysize = this.category.length;
        CategoryItem[] mediumbean = new CategoryItem[categorysize];
        int i2 = 0;
        while (i2 < categorysize) {
            CategoryItem mib;
            mediumbean[i2] = mib = new CategoryItem(profilemap, this.category[i2]);
            ++i2;
        }
        return mediumbean;
    }

    public CategoryItem[] getnewEdit() {
        if (this.category == null) {
            return null;
        }
        HashMap profilemap = new HashMap();
        int categorysize = this.category.length;
        CategoryItem[] mediumbean = new CategoryItem[categorysize];
        int i = 0;
        while (i < categorysize) {
            CategoryItem mib;
            mediumbean[i] = mib = new CategoryItem(profilemap, this.category[i]);
            ++i;
        }
        return mediumbean;
    }
}

