/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.rating.RatingPluginJarManifestNoKeyException;
import jp.co.nri.ridual.r2.rating.RatingPluginJarManifestPluginConfigException;
import jp.co.nri.ridual.r2.rating.RatingPluginJarNoManifestException;
import jp.co.nri.ridual.r2.rating.RatingPluginUnit;

class RatingPluginJar {
    public final String category;
    public final ResourceBundle messages;
    public final String caption;
    public final String prefix;
    public final RatingPluginUnit[] units;
    public static final String MANIFEST_KEY_CATEGORY = "RidualPluginCategory";
    public static final String MANIFEST_KEY_UNITS = "RidualPluginUnits";
    public static final String MANIFEST_KEY_PREFIX = "ridual_prefix";
    private static final String MANIFEST_KEY_MESSAGE_FILE = "ridual_message";
    public static final String MASSAGE_KEY_CAPTION = "caption";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RatingPluginJar(File file) throws IOException, RatingPluginJarNoManifestException, RatingPluginJarManifestNoKeyException, RatingPluginJarManifestPluginConfigException {
        JarFile jar = new JarFile(file);
        try {
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new RatingPluginJarNoManifestException(file);
            }
            Attributes att = manifest.getMainAttributes();
            this.category = this.getAttribute(file, att, MANIFEST_KEY_CATEGORY);
            this.messages = ResourceBundle.getBundle(this.getAttribute(file, att, MANIFEST_KEY_MESSAGE_FILE));
            this.caption = this.messages.getString(MASSAGE_KEY_CAPTION);
            this.prefix = att.getValue(MANIFEST_KEY_PREFIX);
            String[] unitnames = this.split(att.getValue(MANIFEST_KEY_UNITS));
            int len = unitnames.length;
            this.units = new RatingPluginUnit[len];
            int i = 0;
            while (i < len) {
                String name = unitnames[i];
                this.units[i] = new RatingPluginUnit(name, this.split(att.getValue(name)), this.prefix, this.messages);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            jar.close();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        jar.close();
    }

    private String getAttribute(File file, Attributes att, String key) throws RatingPluginJarManifestNoKeyException {
        String val = att.getValue(key);
        if (val == null) {
            throw new RatingPluginJarManifestNoKeyException(file, key);
        }
        return val;
    }

    private String[] split(String str) {
        if (str == null) {
            return new String[0];
        }
        return (str = str.trim()).length() <= 0 ? new String[]{} : Patterns.SP_PATTERN.split(str);
    }
}

