/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.buildreportrobo;

import java.io.File;

class TransformFiles {
    public final int mode;
    public final File htmlfile;
    public final File csvfile;
    public final File xmlfile;
    public final String htmlentry;
    public final String csventry;
    public final String xmlentry;
    private static final String EXT_XML = ".xml";
    private static final String EXT_HTML = ".html";
    private static final String EXT_CSV = ".csv";

    public TransformFiles(int mode, File htmldir, String htmlFilename, File csvdir, String csvFilename, File xmldir, String xmlFilename, String htmlentry, String csventry, String xmlentry) {
        this.mode = mode;
        this.htmlfile = htmlFilename == null ? null : new File(htmldir, htmlFilename);
        this.csvfile = csvFilename == null ? null : new File(csvdir, csvFilename);
        this.xmlfile = xmlFilename == null ? null : new File(xmldir, xmlFilename);
        this.htmlentry = htmlentry;
        this.csventry = csventry;
        this.xmlentry = xmlentry;
    }

    public TransformFiles(int mode, File htmldir, File csvdir, File xmldir, String htmlentry, String csventry, String xmlentry) {
        this.mode = mode;
        this.htmlfile = htmldir;
        this.csvfile = csvdir;
        this.xmlfile = xmldir;
        this.htmlentry = htmlentry;
        this.csventry = csventry;
        this.xmlentry = xmlentry;
    }

    public File buildHtmlFile(String name) {
        return this.htmlfile == null ? null : new File(this.htmlfile, String.valueOf(name) + EXT_HTML);
    }

    public File buildCsvFile(String name) {
        return this.csvfile == null ? null : new File(this.csvfile, String.valueOf(name) + EXT_CSV);
    }

    public File buildXmlFile(String name) {
        return this.xmlfile == null ? null : new File(this.xmlfile, String.valueOf(name) + EXT_XML);
    }

    public String buildHtmlEntry(String name) {
        String filename = String.valueOf(name) + EXT_HTML;
        return this.htmlentry == null ? null : String.valueOf(this.htmlentry) + filename;
    }

    public String buildCsvEntry(String name) {
        String filename = String.valueOf(name) + EXT_CSV;
        return this.csventry == null ? null : String.valueOf(this.csventry) + filename;
    }

    public String buildXmlEntry(String name) {
        String filename = String.valueOf(name) + EXT_XML;
        return this.xmlentry == null ? null : String.valueOf(this.xmlentry) + filename;
    }
}

