/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import java.util.Date;
import java.util.List;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.bean.project.HTMLExistsContainer;
import jp.co.nri.ridual.r2.db.bean.project.HtmlNodeBean;
import jp.co.nri.ridual.r2.db.dao.CSSNodesDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.HtmlNodesDAO;
import jp.co.nri.ridual.r2.db.dao.ParameterPatternDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.apache.commons.lang.time.DateFormatUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentsAndVariationContainer
extends AbstractContentsAndVariationContainer {
    private static final String ELEMENT_NAME_ROOT = "CONTENTS_AND_VARIATION";

    public ContentsAndVariationContainer(ContentsBean contents, ContentsVariationBean variation) {
        super(ELEMENT_NAME_ROOT, contents, variation);
    }

    public Node buildNode(Integer projectId, int mode, Document doc) {
        Element elm = (Element)super.buildNode(projectId, mode, doc);
        super.buildElement(elm, "THUMBNAIL_ID", this.variation.getThumbnailId());
        super.buildTextElement(elm, "METHOD", this.variation.getMethod());
        super.buildIntElement(elm, "TYPE", this.variation.getType());
        super.buildElement(elm, "SIZE", this.variation.getSize());
        super.buildDateElement(elm, "LAST_MODIFIED", this.variation.getLastModified());
        Date lastModified = this.variation.getLastModified();
        if (lastModified != null) {
            super.buildTextElement(elm, "LAST_MODIFIED_FORMAT", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(lastModified));
        }
        super.buildTextElement(elm, "RIDUAL_ENCODING", this.variation.getRidualEncoding());
        super.buildTextElement(elm, "RIDUAL_CONTENT_TYPE", this.variation.getRidualContentType());
        super.buildTextElement(elm, "HTTP_CONTENT_TYPE", this.variation.getHttpContentType());
        super.buildTextElement(elm, "CONTENT_SCRIPT_TYPE", this.variation.getHttpContentScriptType());
        switch (mode) {
            case 7: {
                super.buildTextElement(elm, "EXTENSION", this.contents.getExtension());
            }
        }
        return elm;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        List list = null;
        Integer variationId = this.variation.getId();
        switch (mode) {
            case 3: {
                list = ContentsSupplementDAO.instance.findForReportPages(projectId, variationId);
                int countTagStyle = HtmlNodesDAO.instance.countTagByName(projectId, variationId, "style");
                int countTagScript = HtmlNodesDAO.instance.countTagByName(projectId, variationId, "script");
                int countTagFrameset = HtmlNodesDAO.instance.countTagByName(projectId, variationId, "frameset");
                int countIncludeStyle = HtmlNodesDAO.instance.countByFlag(projectId, variationId, "include.style");
                int countIncludeScript = HtmlNodesDAO.instance.countByFlag(projectId, variationId, "include.script");
                list.add(new HTMLExistsContainer(countIncludeScript, countTagScript, countIncludeStyle, countTagStyle, countTagFrameset));
                return list.toArray(new AbstractNodable[0]);
            }
            case 7: {
                list = ContentsSupplementDAO.instance.findLikeName(projectId, variationId, "IMAGE.%");
                return list.toArray(new AbstractNodable[0]);
            }
            case 4: {
                return ContentsAndVariationDAO.instance.findParentsByVariationId(projectId, variationId).toArray(new AbstractNodable[0]);
            }
            case 8: {
                list = ContentsAndVariationDAO.instance.findParentsByVariationId(projectId, variationId);
                list.addAll(ContentsSupplementDAO.instance.findByName(projectId, variationId, "recheck"));
                Integer paraId = this.variation.getParameterPatternId();
                if (paraId != null && this.variation.getUrlQuery().length() <= 0) {
                    list.add(ParameterPatternDAO.instance.load(projectId, paraId));
                }
                return list.toArray(new AbstractNodable[0]);
            }
            case 6: {
                list = CSSNodesDAO.instance.findSelectorNodesByVariationId(projectId, variationId);
                list.addAll(HtmlNodesDAO.instance.findAttributeByVariationId(projectId, variationId, "style"));
                list.addAll(HtmlNodesDAO.instance.findNodeByTypeAndName(projectId, variationId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "style"));
                return list.toArray(new AbstractNodable[0]);
            }
            case 12: {
                list = ContentsAndVariationDAO.instance.findParentsByVariationId(projectId, variationId);
                list.addAll(ContentsAndVariationDAO.instance.findChildrenByVariationId(projectId, variationId));
                list.addAll(ContentsSupplementDAO.instance.findByVariationId(projectId, variationId));
                list.addAll(HtmlNodesDAO.instance.findNodeByTypeAndName(projectId, variationId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "form"));
                list.addAll(ProjectLogDAO.instance.findByVariationId(projectId, variationId));
                list.addAll(HtmlNodesDAO.instance.findAttributeByVariationId(projectId, variationId, "class"));
                list.addAll(HtmlNodesDAO.instance.findAttributeByVariationId(projectId, variationId, "id"));
                list.addAll(HtmlNodesDAO.instance.findAttributesByVariationIdForScript(projectId, variationId));
                list.addAll(HtmlNodesDAO.instance.findNodeByTypeAndName(projectId, variationId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "script"));
                list.addAll(ContentsAndVariationDAO.instance.findResourcesWithTag(projectId, variationId));
                list.addAll(CSSNodesDAO.instance.findSelectorNodesByVariationId(projectId, variationId));
                list.addAll(HtmlNodesDAO.instance.findAttributeByVariationId(projectId, variationId, "style"));
                return list.toArray(new AbstractNodable[0]);
            }
            case 14: {
                return HtmlNodesDAO.instance.findNodeByTypeAndName(projectId, variationId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "form").toArray(new AbstractNodable[0]);
            }
            case 33: {
                return ContentsAndVariationDAO.instance.findParentsByVariationId(projectId, variationId).toArray(new AbstractNodable[0]);
            }
            case 35: {
                return HtmlNodesDAO.instance.findRoot(projectId, variationId).toArray(new AbstractNodable[0]);
            }
            case 30: {
                list = HtmlNodesDAO.instance.findAttributesByVariationIdForScript(projectId, variationId);
                list.addAll(HtmlNodesDAO.instance.findNodeByTypeAndName(projectId, variationId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "script"));
                return list.toArray(new AbstractNodable[0]);
            }
            case 9: {
                return ProjectLogDAO.instance.findIssueVariation(projectId, this.variation.getId()).toArray(new AbstractNodable[0]);
            }
        }
        return null;
    }
}

