/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.net.URL;
import jp.co.nri.ridual.r2.common.formparamap.FormParaMap;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.bean.project.ParameterPatternBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSet;
import jp.co.nri.ridual.r2.db.dao.DefaultProjectDAO;
import jp.co.nri.ridual.r2.db.dao.HistoryCache;
import jp.co.nri.ridual.r2.db.dao.LoadOrSaveContainer;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class ContentsDAO
extends DefaultProjectDAO {
    public static final ContentsDAO instance = new ContentsDAO();

    private ContentsDAO() {
        super(1);
    }

    public ContentsSet loadOrSaveWithVatiation(Integer projectId, Integer historyId, URL parentURL, String uristr, boolean isPost, String cookie) throws Throwable {
        try {
            ContentsBean contents = new ContentsBean();
            ContentsVariationBean variation = new ContentsVariationBean();
            variation.setMethod(isPost ? "POST" : "GET");
            contents.setHistoryId(historyId);
            URL url = parentURL == null ? contents.setURL(uristr) : contents.setURL(parentURL, uristr);
            String urlFragment = null;
            if (url != null) {
                HistoryCache historyCache = AnalyzeHistoryDAO.instance.getCache(historyId);
                Boolean isInner = historyCache.isInner(url);
                contents.setIsInner(isInner);
                variation.setUrlQuery(url.getQuery());
                variation.setUrlUserInfo(url.getUserInfo());
                if (isInner.booleanValue()) {
                    variation.setCookie(cookie);
                }
                urlFragment = url.getRef();
            }
            LoadOrSaveContainer contentsContainer = super.loadOrSave(projectId, "contents.findByURL", contents);
            contents = (ContentsBean)contentsContainer.bean;
            variation.setContentsId(contents.getId());
            LoadOrSaveContainer variationContainer = super.loadOrSave(projectId, "contentsVariation.findByUnique", variation);
            return new ContentsSet(contents, contentsContainer.isLoad, (ContentsVariationBean)variationContainer.bean, variationContainer.isLoad, urlFragment);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents", e);
            throw e;
        }
    }

    public ContentsSet[] loadOrSaveWithVatiation(Integer projectId, Integer historyId, URL parentURL, String uristr, boolean isPost, String cookie, FormParaMap[] formParaMaps) throws Throwable {
        try {
            ContentsBean contents = new ContentsBean();
            String method = isPost ? "POST" : "GET";
            contents.setHistoryId(historyId);
            URL url = parentURL == null ? contents.setURL(uristr) : contents.setURL(parentURL, uristr);
            String urlFragment = null;
            String urlQuery = null;
            String urlUserInfo = null;
            if (url != null) {
                HistoryCache historyCache = AnalyzeHistoryDAO.instance.getCache(historyId);
                contents.setIsInner(historyCache.isInner(url));
                urlQuery = url.getQuery();
                urlUserInfo = url.getUserInfo();
                urlFragment = url.getRef();
            }
            SessionFactory factory = super.getSessionFactory(projectId);
            Session session = factory.openSession();
            RetryOverException roe = new RetryOverException(factory);
            while (true) {
                try {
                    ContentsSet[] contentsSetArray;
                    try {
                        LoadOrSaveContainer contentsContainer = this.loadOrSaveContents(contents, (org.hibernate.Session)session);
                        contents = (ContentsBean)contentsContainer.bean;
                        Integer contentsId = contents.getId();
                        int len = formParaMaps.length;
                        ContentsSet[] contentsSets = new ContentsSet[len];
                        int i = 0;
                        while (i < len) {
                            contentsSets[i] = this.loadOrSaveParameterPatternAndVariation(contentsId, method, urlQuery, urlUserInfo, urlFragment, contents, contentsContainer.isLoad, cookie, formParaMaps[i], (org.hibernate.Session)session);
                            ++i;
                        }
                        contentsSetArray = contentsSets;
                        Object var22_25 = null;
                    }
                    catch (Throwable throwable) {
                        Object var22_26 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return contentsSetArray;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents", e);
            throw e;
        }
    }

    private ContentsSet loadOrSaveParameterPatternAndVariation(Integer contentsId, String method, String urlQuery, String urlUserInfo, String urlFragment, ContentsBean contents, boolean isLoad, String cookie, FormParaMap map, org.hibernate.Session session) throws Throwable {
        Transaction transaction = session.beginTransaction();
        try {
            Integer parameterPatternId = this.loadOrSaveParameterPatternBean(contentsId, map.buildParameterPatternString(urlQuery), session);
            ContentsVariationBean variation = new ContentsVariationBean();
            variation.setContentsId(contentsId);
            variation.setMethod(method);
            variation.setUrlUserInfo(urlUserInfo);
            if (contents.getIsInner().booleanValue()) {
                variation.setCookie(cookie);
            }
            variation.setUrlQuery(map.buildQueryString(urlQuery));
            variation.setParameterPatternId(parameterPatternId);
            String qname = parameterPatternId == null ? "contentsVariation.findByUnique" : "contentsVariation.findByUniqueWithPP";
            LoadOrSaveContainer variationContainer = super.loadOrSave(qname, (Object)variation, session);
            transaction.commit();
            return new ContentsSet(contents, isLoad, (ContentsVariationBean)variationContainer.bean, variationContainer.isLoad, urlFragment);
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }

    private LoadOrSaveContainer loadOrSaveContents(ContentsBean contents, org.hibernate.Session session) throws Throwable {
        Transaction transaction = session.beginTransaction();
        try {
            LoadOrSaveContainer contentsContainer = super.loadOrSave("contents.findByURL", (Object)contents, session);
            transaction.commit();
            return contentsContainer;
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }

    private Integer loadOrSaveParameterPatternBean(Integer contentsId, String para, org.hibernate.Session session) throws Throwable {
        if (para == null) {
            return null;
        }
        ParameterPatternBean bean = new ParameterPatternBean();
        bean.setContentsId(contentsId);
        bean.setpattern(para);
        Transaction transaction = session.beginTransaction();
        try {
            LoadOrSaveContainer losContainer = super.loadOrSave("parameterPattern.findUnique", (Object)bean, session);
            transaction.commit();
            return ((ParameterPatternBean)losContainer.bean).getId();
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }
}

