/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Canvas;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.jdesktop.jdic.browser.NativeEventThread;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class WebBrowser
extends Canvas {
    private MyFocusListener focusListener = new MyFocusListener();
    private static NativeEventThread eventThread;
    private Vector webBrowserListeners = new Vector();
    private int instanceNum;
    private static int lastInstanceNum;
    private static boolean isRunningOnWindows;
    private boolean isInitialized = false;
    private boolean isBackEnabled = false;
    private boolean isForwardEnabled = false;
    private String initFailureMessage = "WebBrowser is not initialized.";

    void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    void setInitFailureMessage(String string) {
        this.initFailureMessage = string;
    }

    public WebBrowser() {
        this((URL)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBrowser(URL uRL) {
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            this.instanceNum = lastInstanceNum++;
        }
        eventThread.attachWebBrowser(this);
        if (0 == this.instanceNum) {
            WebBrowserUtil.getEmbedBinaryName();
            eventThread.start();
            eventThread.fireNativeEvent(this.instanceNum, 0);
        }
        if (null != uRL) {
            this.setURL(uRL);
        }
        this.setFocusable(true);
        this.addFocusListener(this.focusListener);
    }

    public void addNotify() {
        super.addNotify();
        eventThread.fireNativeEvent(this.instanceNum, 1);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        eventThread.fireNativeEvent(this.instanceNum, 4, new Rectangle(n, n2, n3, n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchWebBrowserEvent(WebBrowserEvent webBrowserEvent) {
        Vector vector;
        int n;
        int n2 = webBrowserEvent.getID();
        WebBrowserUtil.trace("Got event from NativeEventThread " + n2);
        String string = "@" + this.instanceNum + "," + n2 + ",";
        if (3001 == n2) {
            URL uRL = null;
            try {
                uRL = new URL(webBrowserEvent.getData());
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL("file:/" + webBrowserEvent.getData());
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            string = string + (this.willOpenURL(uRL) ? "0" : "1");
            WebBrowser.eventThread.messenger.sendMessage(string);
            return;
        }
        if (3002 == n2) {
            string = string + (this.willOpenWindow() ? "0" : "1");
            WebBrowser.eventThread.messenger.sendMessage(string);
            return;
        }
        if (3022 == n2) {
            String string2 = webBrowserEvent.getData();
            if (string2.startsWith("forward")) {
                this.isForwardEnabled = string2.substring(8).equals("1");
                WebBrowserUtil.trace("Forward State changed = " + this.isForwardEnabled);
            } else if (string2.startsWith("back")) {
                this.isBackEnabled = string2.substring(5).equals("1");
                WebBrowserUtil.trace("Back State changed = " + this.isBackEnabled);
            }
            return;
        }
        if (3043 == n2) {
            WebBrowserUtil.trace("Got Event from brower: Focus Rquest!");
            this.requestFocus();
            return;
        }
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            n = this.webBrowserListeners.size();
            if (n == 0) {
                return;
            }
            vector = (Vector)this.webBrowserListeners.clone();
        }
        block16: for (int i = 0; i < n; ++i) {
            WebBrowserListener webBrowserListener = (WebBrowserListener)vector.elementAt(i);
            switch (n2) {
                case 3003: {
                    webBrowserListener.downloadStarted(webBrowserEvent);
                    continue block16;
                }
                case 3004: {
                    webBrowserListener.downloadCompleted(webBrowserEvent);
                    continue block16;
                }
                case 3005: {
                    webBrowserListener.downloadProgress(webBrowserEvent);
                    continue block16;
                }
                case 3006: {
                    webBrowserListener.downloadError(webBrowserEvent);
                    continue block16;
                }
                case 3007: {
                    webBrowserListener.documentCompleted(webBrowserEvent);
                    continue block16;
                }
                case 3023: {
                    webBrowserListener.titleChange(webBrowserEvent);
                    continue block16;
                }
                case 3024: {
                    webBrowserListener.statusTextChange(webBrowserEvent);
                }
            }
        }
    }

    public synchronized void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (!this.webBrowserListeners.contains(webBrowserListener)) {
            this.webBrowserListeners.addElement(webBrowserListener);
        }
    }

    public synchronized void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (webBrowserListener == null) {
            return;
        }
        this.webBrowserListeners.removeElement(webBrowserListener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return (WebBrowserListener[])this.webBrowserListeners.toArray();
    }

    public URL getURL() {
        eventThread.fireNativeEvent(this.instanceNum, 12);
        if (this.waitForResult()) {
            try {
                return new URL(WebBrowser.eventThread.eventRetString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setURL() {
        eventThread.fireNativeEvent(this.instanceNum, 5, "about:blank");
    }

    public void setURL(URL uRL) {
        this.setURL(uRL, null);
    }

    public void setURL(URL uRL, String string) {
        if (string == null) {
            eventThread.fireNativeEvent(this.instanceNum, 5, uRL.toString());
        } else {
            eventThread.fireNativeEvent(this.instanceNum, 6, uRL.toString());
            eventThread.fireNativeEvent(this.instanceNum, 7, string);
        }
    }

    public void back() {
        eventThread.fireNativeEvent(this.instanceNum, 8);
    }

    public void forward() {
        eventThread.fireNativeEvent(this.instanceNum, 9);
    }

    public void refresh() {
        eventThread.fireNativeEvent(this.instanceNum, 10);
    }

    public void stop() {
        eventThread.fireNativeEvent(this.instanceNum, 11);
    }

    public void setContent(String string) {
        eventThread.fireNativeEvent(this.instanceNum, 16, string);
    }

    public String getContent() {
        eventThread.fireNativeEvent(this.instanceNum, 15);
        if (this.waitForResult()) {
            try {
                return WebBrowser.eventThread.eventRetString;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String executeScript(String string) {
        eventThread.fireNativeEvent(this.instanceNum, 17, string);
        if (this.waitForResult()) {
            try {
                return WebBrowser.eventThread.eventRetString;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setDebug(boolean bl) {
        WebBrowserUtil.enableDebugMessages(bl);
    }

    public Status getStatus() {
        return new Status(this);
    }

    public static String getBrowserBinary() {
        return WebBrowserUtil.getEmbedBinaryName();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isBackEnabled() {
        return this.isBackEnabled;
    }

    public boolean isForwardEnabled() {
        return this.isForwardEnabled;
    }

    protected boolean willOpenURL(URL uRL) {
        if (null == uRL) {
            return true;
        }
        WebBrowserUtil.trace("URL = " + uRL.toString());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }
        return true;
    }

    protected boolean willOpenWindow() {
        return true;
    }

    int getInstanceNum() {
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult() {
        if (!this.isInitialized) {
            WebBrowserUtil.trace("You can't call this method before WebBrowser is initialized!");
            return false;
        }
        boolean bl = false;
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            try {
                this.wait();
                bl = true;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return bl;
    }

    int getNativeWindow() {
        return this.nativeGetWindow(System.getProperty("java.home"));
    }

    private native int nativeGetWindow(String var1);

    static {
        lastInstanceNum = 0;
        isRunningOnWindows = false;
        try {
            JdicManager jdicManager = JdicManager.getManager();
            jdicManager.initShareNative();
            jdicManager.initBrowserNative();
        }
        catch (JdicInitException jdicInitException) {
            jdicInitException.printStackTrace();
        }
        eventThread = new NativeEventThread();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("jdic");
                return null;
            }
        });
        isRunningOnWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            WebBrowserUtil.trace("\nMyFocusListener: focusGained\n");
            eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 13);
        }

        public void focusLost(FocusEvent focusEvent) {
            WebBrowserUtil.trace("\nMyFocusListener: focusLost\n");
            eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 14);
        }
    }

    public static class Status {
        WebBrowser webBrowser;

        Status(WebBrowser webBrowser) {
            this.webBrowser = webBrowser;
        }

        public boolean isInitialized() {
            return this.webBrowser.isInitialized();
        }

        public boolean isBackEnabled() {
            return this.webBrowser.isBackEnabled();
        }

        public boolean isForwardEnabled() {
            return this.webBrowser.isForwardEnabled();
        }
    }
}

