<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<!-- サイト1件についての情報 -->
<xsl:template match="ANALYZE_SITE_CONFIG">
	Depth-limit : <xsl:value-of select="DEPTH_LIMIT"/>,
	File-count-limit:<xsl:value-of select="FILE_COUNT_LIMIT"/>
</xsl:template>

<!-- LOCAL HISTORY 1件についての情報 -->
<xsl:template match="LOCAL_HISTORY">
	<form action="dellocal" method="post">
	<ul>
		<li>
			<xsl:value-of select="TIMESTAMP"/>
			<xsl:apply-templates select="ANALYZE_SITE_CONFIG"/>
			<p>
				<a href="{ANALYZE_SITE_CONFIG/START_URIS}">
					<xsl:value-of select="ANALYZE_SITE_CONFIG/START_URIS"/>
				</a>
			</p>
		</li>
	</ul>
	
	<input name="lh" type="hidden" value="{ID}"/>
	<input alt="OK" class="ok" src="img/btn_ok.gif" type="image"/>
	</form>
</xsl:template>

<!-- HISTORY 1件についての情報 -->
<xsl:template match="ANALYZE_HISTORY">
	<form action="delhistory" method="post">
	<ul>
		<li>
			<xsl:value-of select="TIMESTAMP_BEGIN"/>
			<xsl:apply-templates select="ANALYZE_SITE_CONFIG"/>
			
			<xsl:if test="COUNT_COMPLETE">
				(<xsl:value-of select="COUNT_COMPLETE"/>/<xsl:value-of select="COUNT_ALL"/>)
			</xsl:if>
			<p>
				<a href="{ANALYZE_SITE_CONFIG/START_URIS}">
					<xsl:value-of select="ANALYZE_SITE_CONFIG/START_URIS"/>
				</a>
			</p>
		</li>
	</ul>

	<input name="h" type="hidden" value="{ID}"/>
	<input alt="OK" class="ok" src="img/btn_ok.gif" type="image"/>
	</form>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Sitelist</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="message">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualDialogDelete"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualDialogDelete">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	
	</div>
	<!-- #header -->

	<hr/>

	<!-- #content -->
	<div id="content">

	<!-- #msgbox -->
	<div id="msgbox">

	<!-- #delete -->
	<div id="delete">

	<!-- #ms -->
	<div id="ms">
		<h1>注意</h1>
		<p>下記の(history/Local)情報を完全に消去しますか？</p>
	</div>
	<!-- /#ms -->

	<xsl:apply-templates select="ANALYZE_HISTORY"/>
	<xsl:apply-templates select="LOCAL_HISTORY"/>

	<p>注意</p>
	<ol>
		<li>生成されたHTMLも消去されます</li>
		<li>NOの場合は、ブラウザのバックボタンで戻ってください</li>
	</ol>
	
	</div>
	<!-- /#delete -->

	</div>
	<!-- /#msgbox -->
	
	</div>
	<!-- /#content -->
</xsl:template>

</xsl:stylesheet>
