<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="progress">
	(
	<xsl:choose>
		<xsl:when test="TIMESTAMP_COMPLETE">
			done
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="COUNT_COMPLETE"/>/<xsl:value-of select="COUNT_ALL"/>
		</xsl:otherwise>
	</xsl:choose>
	)
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
<xsl:param name="hid"/>
	<span class="label">
		<input type="radio" name="h" value="{ID}">
			<xsl:if test="ID=$hid">
				<xsl:attribute name="checked">checked</xsl:attribute>
			</xsl:if>
		</input>
	</span>
	<span class="control">
		<xsl:value-of select="TIMESTAMP_BEGIN"/>
		<xsl:call-template name="progress"/>
	</span><br/>
</xsl:template>

<xsl:template match="DIRECTORY_MAP">
	<p>
		<a href="{URL}"><xsl:value-of select="URL"/></a>
		<xsl:text> : </xsl:text>
		<a href="file:///{DIR}">file:///<xsl:value-of select="DIR"/></a>
	</p>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Sitelist</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="message">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualLocalMapping"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualLocalMapping">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	
	</div>
	<!-- #header -->

	<hr/>

	<!-- #content -->
	<div id="content">
		<xsl:apply-templates select="LOCAL_HISTORY"/>

		<!-- #msglist -->
		<div id="msglist">
		<form action="setlocal" method="post">
			<input name="lh" type="hidden" value="{LOCAL_HISTORY/ID}"/>
			<input alt="送信" class="send" src="img/btn_send.gif" type="image"/>
			<br/>
			<xsl:apply-templates select="ANALYZE_HISTORY">
				<xsl:with-param name="hid" select="LOCAL_HISTORY/HISTORY_ID"/>
			</xsl:apply-templates>
			
			<input alt="送信" class="send" src="img/btn_send.gif" type="image"/>
			<br/>
		</form>
		
		</div>
		<!-- /#msglist -->
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="LOCAL_HISTORY">
	<!-- #msgbox -->
	<div id="msgbox">
	
	<!-- #choice -->
	<div id="choice">
	
	<!-- #ms -->
	<div id="ms">
		<h1>確認</h1>
		<p>下記の(local)情報と関連付ける(history)情報を選択してください：</p>
	</div>
	<!-- /#ms -->

	<ul>
		<li>
			<xsl:value-of select="TIMESTAMP"/>
			<xsl:apply-templates select="DIRECTORY_MAP"/>
		</li>
	</ul>

	</div>
	<!-- /#choice -->

	</div>
	<!-- /#msgbox -->
</xsl:template>

</xsl:stylesheet>
