<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<span class="c0an">未解析</span>
		</xsl:when>
		<xsl:when test="$status=-2">
			unknown-host
		</xsl:when>
		<xsl:when test="$status=-3">
			connect-error
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<span class="c0in">情報</span>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<span class="c0uk">不明</span>
		</xsl:when>
		<xsl:when test="(100 &lt;= $status) and ($status &lt; 200)">
			<span class="c100"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(200 &lt;= $status) and ($status &lt; 300)">
			<span class="c200"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(300 &lt;= $status) and ($status &lt; 400)">
			<span class="c300"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(400 &lt;= $status) and ($status &lt; 500)">
			<span class="c400"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(500 &lt;= $status) and ($status &lt; 600)">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="600 &lt;= $status">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="c5ov"><xsl:value-of select="$status"/></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- <script> -->
<xsl:template match="HTML_ELEMENT">
	<li>
		&lt;<xsl:value-of select="NAME"/><xsl:apply-templates select="HTML_ATTRIBUTE"/>&gt;
		<xsl:apply-templates select="HTML_TEXT"/>
	</li>
</xsl:template>

<xsl:template match="HTML_ATTRIBUTE">
	<xsl:text> </xsl:text>
	<xsl:value-of select="NAME"/>=&quot;<xsl:value-of select="VALUE"/>&quot;
</xsl:template>

<xsl:template match="HTML_TEXT">
	<p><pre><xsl:value-of select="."/></pre></p>
</xsl:template>

<!-- event + "javascript:..."リンク -->
<xsl:template match="HTML_ATTRIBUTE_WITH_TAG">
	<li>
		&lt;<xsl:value-of select="TAG"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="NAME"/>=&quot;<xsl:value-of select="VALUE"/>&quot;&gt;
	</li>
</xsl:template>

<!-- JSファイル 1件分の情報 -->
<xsl:template match="CONTENTS_AND_VARIATION">
	<li>
	<xsl:choose>
		<xsl:when test="TYPE=273">
			<img alt="detail" src="../../img/detail.gif" height="22" width="22"/>
		</xsl:when>
		<xsl:otherwise>
			<img alt="JavaScript file" src="../../img/js.gif" height="16" width="16"/>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text> </xsl:text>
	<a href="{URL}" target="_blank"><xsl:value-of select="URL"/></a>
	<xsl:text> (</xsl:text>
	<xsl:value-of select="HTTP_CONTENT_TYPE"/>
	<xsl:text>, status=</xsl:text>
	<xsl:call-template name="httpstatus">
		<xsl:with-param name="status" select="HTTP_STATUS"/>
	</xsl:call-template>
	<xsl:text>) </xsl:text>
	
	<!-- <script> -->
	<div class="boxscrl">
		<ul>
			<xsl:apply-templates select="HTML_ELEMENT"/>
		</ul>
		
		<!-- event + "javascript:..."リンク -->
		<ul>
			<xsl:apply-templates select="HTML_ATTRIBUTE_WITH_TAG"/>
		</ul>
	</div>
	
	</li>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual：Script</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="script">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportScript"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportScript">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Script</h1>
		<p class="xmlicon"><a href="xml/script.xml">XML</a></p>
		<p class="csvicon"><a href="csv/script.csv">CSV</a></p>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
<!--
		<p>スクリプトファイル[<xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>]</p>
		<p>check date:yyyy/mm/dd hh:mm:ss</p>
-->
		<!-- #switch -->
		<div id="switch">
			<p class="description">Script list</p>
			<br/>
		</div>
		<!-- /#switch -->

		<!-- .box -->
		<div class="box">
			
			<!-- JSファイル + script関連を持ったhtml -->
			<ol>
				<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
			</ol>
		</div>
		<!-- /.box -->
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a href="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
