<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	
	<head>
		<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
		<title>Ridual：Admin-ServerLog</title>
		<link href="mailto:ridual@nri.co.jp" rev="made"/>
		<link title="Ridual" href="../css/import_style.css" rel="stylesheet"
										type="text/css" media="screen,print"/>
	<link href="../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="serverlog">

	<!-- #layout -->
	<div id="layout">
	
		<xsl:apply-templates select="RidualServerLog"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	
	</html>
</xsl:template>

<xsl:template match="RidualServerLog">

	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../sitelist">Sitelist</a></li>
				<li class="admin"><a href="setup">Admin</a></li>
				<li class="help"><a href="../help/help.html">Help</a></li>
			</ul>

		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<p>Admin</p>
		</div>
		<!-- /#line -->

		<!-- #menu -->
		<div id="menu">
			<ul>
				<li class="setup"><a href="setup">Setup</a></li>
				<li class="serverlog"><a href="serverlog">ServerLog</a></li>
				<li class="logout"><a href="../index.html">Logout</a></li>
				<li class="adhelp"><a href="adhelp.html">Help</a></li>
			</ul>
		</div>
		<!-- /#menu -->
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Serverlog</h1>	
	</div>

	<!-- #content -->
	<div id="content">
		<ul>
		<xsl:apply-templates select="RIDUAL_SERVER_LOG"/>
		</ul>
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="RIDUAL_SERVER_LOG">
	<li>
		<p><xsl:value-of select="TIMESTAMP"/>
		method:<xsl:value-of select="METHOD"/>
		code:<xsl:value-of select="CODE"/></p>
		<p><xsl:value-of select="MESSAGE"/></p>
		<ul>
		<xsl:apply-templates select="RIDUAL_SERVER_LOG_SUPPLEMENT"/>
		</ul>
	</li>
</xsl:template>
	
<xsl:template match="RIDUAL_SERVER_LOG_SUPPLEMENT">
	<li>
	<xsl:value-of select="NAME"/>
	<p><pre><xsl:value-of select="VALUE"/></pre></p>
	</li>
</xsl:template>

</xsl:stylesheet>
